/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.messages;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class TcpDiscoveryAbstractMessage
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected static final int CLIENT_FLAG_POS = 0;
    protected static final int RESPONDED_FLAG_POS = 1;
    protected static final int CLIENT_RECON_SUCCESS_FLAG_POS = 2;
    protected static final int CHANGE_TOPOLOGY_FLAG_POS = 3;
    protected static final int CLIENT_ACK_FLAG_POS = 4;
    protected static final int FORCE_FAIL_FLAG_POS = 8;
    private transient UUID sndNodeId;
    private IgniteUuid id;
    private UUID verifierNodeId;
    private long topVer;
    @GridToStringExclude
    private int flags;
    private short pendingIdx;
    @GridToStringInclude
    private Set<UUID> failedNodes;

    protected TcpDiscoveryAbstractMessage() {
    }

    protected TcpDiscoveryAbstractMessage(UUID creatorNodeId) {
        this.id = IgniteUuid.fromUuid(creatorNodeId);
    }

    protected TcpDiscoveryAbstractMessage(TcpDiscoveryAbstractMessage msg) {
        this.id = msg.id;
        this.verifierNodeId = msg.verifierNodeId;
        this.topVer = msg.topVer;
        this.flags = msg.flags;
        this.pendingIdx = msg.pendingIdx;
    }

    public boolean traceLogLevel() {
        return false;
    }

    public UUID creatorNodeId() {
        return this.id.globalId();
    }

    public IgniteUuid id() {
        return this.id;
    }

    public UUID senderNodeId() {
        return this.sndNodeId;
    }

    public void senderNodeId(UUID sndNodeId) {
        this.sndNodeId = sndNodeId;
    }

    public boolean verified() {
        return this.verifierNodeId != null;
    }

    public UUID verifierNodeId() {
        return this.verifierNodeId;
    }

    public void verify(UUID verifierNodeId) {
        this.verifierNodeId = verifierNodeId;
    }

    public long topologyVersion() {
        return this.topVer;
    }

    public void topologyVersion(long topVer) {
        this.topVer = topVer;
    }

    public boolean client() {
        return this.getFlag(0);
    }

    public void client(boolean client) {
        this.setFlag(0, client);
    }

    public boolean force() {
        return this.getFlag(8);
    }

    public void force(boolean force) {
        this.setFlag(8, force);
    }

    public short pendingIndex() {
        return this.pendingIdx;
    }

    public void pendingIndex(short pendingIdx) {
        this.pendingIdx = pendingIdx;
    }

    protected boolean getFlag(int pos) {
        assert (pos >= 0 && pos < 32);
        int mask = 1 << pos;
        return (this.flags & mask) == mask;
    }

    protected void setFlag(int pos, boolean val) {
        assert (pos >= 0 && pos < 32);
        int mask = 1 << pos;
        this.flags = val ? (this.flags |= mask) : (this.flags &= ~mask);
    }

    public boolean highPriority() {
        return false;
    }

    public void addFailedNode(UUID nodeId) {
        assert (nodeId != null);
        if (this.failedNodes == null) {
            this.failedNodes = new HashSet<UUID>();
        }
        this.failedNodes.add(nodeId);
    }

    public void failedNodes(@Nullable Set<UUID> failedNodes) {
        this.failedNodes = failedNodes;
    }

    @Nullable
    public Collection<UUID> failedNodes() {
        return this.failedNodes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TcpDiscoveryAbstractMessage) {
            return this.id.equals(((TcpDiscoveryAbstractMessage)obj).id);
        }
        return false;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return S.toString(TcpDiscoveryAbstractMessage.class, this, "isClient", (Object)this.getFlag(0));
    }
}

