/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class SqlAlterTableCommand
implements SqlCommand {
    private String schemaName;
    private String tblName;
    private Boolean logging;

    public SqlAlterTableCommand() {
    }

    public SqlAlterTableCommand(String schemaName, String tblName, boolean ifExists, boolean logging) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.logging = logging;
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public void schemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    @Nullable
    public Boolean logging() {
        return this.logging;
    }

    @Override
    public SqlCommand parse(SqlLexer lex) {
        SqlQualifiedName tblQName = SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]);
        this.schemaName = tblQName.schemaName();
        this.tblName = tblQName.name();
        this.parseLogging(lex);
        if (!this.hasCommands()) {
            throw SqlParserUtils.errorUnexpectedToken(lex, "LOGGING", "NOLOGGING");
        }
        return this;
    }

    private void parseLogging(SqlLexer lex) {
        SqlLexerToken token = lex.lookAhead();
        if (SqlParserUtils.matchesKeyword(token, "LOGGING")) {
            lex.shift();
            this.logging = true;
        } else if (SqlParserUtils.matchesKeyword(token, "NOLOGGING")) {
            lex.shift();
            this.logging = false;
        }
    }

    private boolean hasCommands() {
        return this.logging != null;
    }

    public String toString() {
        return S.toString(SqlAlterTableCommand.class, this);
    }
}

