/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.disaster.system.exception.MigrateException;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;

@Singleton
@Requires(classes={ExceptionHandler.class})
public class MigrateExceptionHandler
implements ExceptionHandler<MigrateException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, MigrateException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).detail(exception.getMessage()).traceId(exception.traceId()).code(exception.codeAsString()));
    }
}

