/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import java.util.Set;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;

@Singleton
@Requires(classes={IgniteException.class, ExceptionHandler.class})
public class IgniteExceptionHandler
implements ExceptionHandler<IgniteException, HttpResponse<? extends Problem>> {
    private static final Set<Integer> BAD_REQUEST_CODES = Set.of(Integer.valueOf(ErrorGroups.Table.TABLE_NOT_FOUND_ERR));

    public HttpResponse<? extends Problem> handle(HttpRequest request, IgniteException exception) {
        if (exception.getCause() instanceof IllegalArgumentException || BAD_REQUEST_CODES.contains(exception.code())) {
            return HttpProblemResponse.from(Problem.fromIgniteException(exception, HttpCode.BAD_REQUEST).build());
        }
        return HttpProblemResponse.from(Problem.fromIgniteException(exception, HttpCode.INTERNAL_SERVER_ERROR).build());
    }
}

