/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client;

import java.util.UUID;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.network.NetworkAddress;
import org.apache.ignite3.network.NodeMetadata;
import org.jetbrains.annotations.Nullable;

public class ClientClusterNode
implements ClusterNode {
    private final UUID id;
    private final String name;
    private final NetworkAddress address;
    @Nullable
    private final NodeMetadata nodeMetadata;

    public ClientClusterNode(UUID id, String name, NetworkAddress address, @Nullable NodeMetadata nodeMetadata) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.nodeMetadata = nodeMetadata;
    }

    public ClientClusterNode(UUID id, String name, NetworkAddress address) {
        this(id, name, address, null);
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public NetworkAddress address() {
        return this.address;
    }

    @Override
    @Nullable
    public NodeMetadata nodeMetadata() {
        return this.nodeMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientClusterNode that = (ClientClusterNode)o;
        return this.name.equals(that.name) && this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }

    public String toString() {
        return S.toString(ClientClusterNode.class, this);
    }
}

