/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.message.TxMetaMessage;
import org.apache.ignite3.internal.tx.message.TxMetaMessageBuilder;
import org.apache.ignite3.internal.tx.message.TxMetaMessageSerializer;

public class TxMetaMessageImpl
implements TxMetaMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 14;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final List<EnlistedPartitionGroupMessage> enlistedPartitions;
    @IgniteToStringInclude
    private final TxState txState;

    private TxMetaMessageImpl(HybridTimestamp commitTimestamp, List<EnlistedPartitionGroupMessage> enlistedPartitions, TxState txState) {
        this.commitTimestamp = commitTimestamp;
        this.enlistedPartitions = enlistedPartitions;
        this.txState = txState;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public List<EnlistedPartitionGroupMessage> enlistedPartitions() {
        return this.enlistedPartitions;
    }

    @Override
    public TxState txState() {
        return this.txState;
    }

    public MessageSerializer serializer() {
        return TxMetaMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxMetaMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 14;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxMetaMessageImpl otherMessage = (TxMetaMessageImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.enlistedPartitions, otherMessage.enlistedPartitions) && Objects.equals((Object)this.txState, (Object)otherMessage.txState);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.commitTimestamp, this.enlistedPartitions, this.txState});
        return result;
    }

    @Override
    public TxMetaMessageImpl clone() {
        try {
            return (TxMetaMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxMetaMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.enlistedPartitions != null) {
            for (EnlistedPartitionGroupMessage obj : this.enlistedPartitions) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.enlistedPartitions != null) {
            for (EnlistedPartitionGroupMessage obj : this.enlistedPartitions) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements TxMetaMessageBuilder {
        private HybridTimestamp commitTimestamp;
        private List<EnlistedPartitionGroupMessage> enlistedPartitions;
        private TxState txState;

        private Builder() {
        }

        @Override
        public TxMetaMessageBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public TxMetaMessageBuilder enlistedPartitions(List<EnlistedPartitionGroupMessage> enlistedPartitions) {
            Objects.requireNonNull(enlistedPartitions, "enlistedPartitions is not marked @Nullable");
            this.enlistedPartitions = enlistedPartitions;
            return this;
        }

        @Override
        public TxMetaMessageBuilder txState(TxState txState) {
            Objects.requireNonNull(txState, "txState is not marked @Nullable");
            this.txState = txState;
            return this;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public List<EnlistedPartitionGroupMessage> enlistedPartitions() {
            return this.enlistedPartitions;
        }

        @Override
        public TxState txState() {
            return this.txState;
        }

        @Override
        public TxMetaMessage build() {
            return new TxMetaMessageImpl(this.commitTimestamp, Objects.requireNonNull(this.enlistedPartitions, "enlistedPartitions is not marked @Nullable"), Objects.requireNonNull(this.txState, "txState is not marked @Nullable"));
        }
    }
}

