/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.streamer.StreamerBatchSender;
import org.apache.ignite3.internal.streamer.StreamerOptions;
import org.apache.ignite3.internal.streamer.StreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.streamer.StreamerSubscriber;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOperationType;
import org.apache.ignite3.table.DataStreamerOptions;
import org.jetbrains.annotations.Nullable;

class DataStreamer {
    private static final IgniteLogger LOG = Loggers.forClass(DataStreamer.class);

    DataStreamer() {
    }

    static <R> CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options, StreamerBatchSender<R, Integer, Void> batchSender, StreamerPartitionAwarenessProvider<R, Integer> partitionAwarenessProvider, ScheduledExecutorService flushExecutor) {
        return DataStreamer.streamData(publisher, DataStreamerItem::get, DataStreamerItem::get, x -> x.operationType() == DataStreamerOperationType.REMOVE, options, batchSender, null, partitionAwarenessProvider, flushExecutor);
    }

    static <T, E, V, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, T> keyFunc, Function<E, V> payloadFunc, Function<E, Boolean> deleteFunc, @Nullable DataStreamerOptions options, StreamerBatchSender<V, Integer, R> batchSender, @Nullable Flow.Subscriber<R> resultSubscriber, StreamerPartitionAwarenessProvider<T, Integer> partitionAwarenessProvider, ScheduledExecutorService flushExecutor) {
        StreamerOptions streamerOpts = DataStreamer.streamerOptions(options);
        StreamerSubscriber<T, E, V, R, Integer> subscriber = new StreamerSubscriber<T, E, V, R, Integer>(batchSender, resultSubscriber, keyFunc, payloadFunc, deleteFunc, partitionAwarenessProvider, streamerOpts, flushExecutor, LOG, null);
        publisher.subscribe(subscriber);
        return subscriber.completionFuture();
    }

    private static StreamerOptions streamerOptions(@Nullable DataStreamerOptions options) {
        final DataStreamerOptions options0 = options == null ? DataStreamerOptions.DEFAULT : options;
        return new StreamerOptions(){

            @Override
            public int pageSize() {
                return options0.pageSize();
            }

            @Override
            public int perPartitionParallelOperations() {
                return options0.perPartitionParallelOperations();
            }

            @Override
            public int autoFlushInterval() {
                return options0.autoFlushInterval();
            }
        };
    }
}

