/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.raft.ThrottlingContextHolder;
import org.apache.ignite3.internal.raft.configuration.RaftConfiguration;
import org.apache.ignite3.internal.util.SlidingHistogram;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ThrottlingContextHolderImpl
implements ThrottlingContextHolder {
    private static final IgniteLogger LOG = Loggers.forClass(ThrottlingContextHolder.class);
    private final RaftConfiguration configuration;
    private final double maxInflightOverflowRate;
    private final Map<String, PeerContextHolder> peerContexts = new ConcurrentHashMap<String, PeerContextHolder>();

    @TestOnly
    public ThrottlingContextHolderImpl(RaftConfiguration configuration) {
        this(configuration, 1.3);
    }

    public ThrottlingContextHolderImpl(RaftConfiguration configuration, double maxInflightOverflowRate) {
        this.configuration = configuration;
        this.maxInflightOverflowRate = maxInflightOverflowRate;
    }

    @Override
    public boolean isOverloaded() {
        throw new AssertionError((Object)"This method should be called on the peer context.");
    }

    @Override
    public void beforeRequest() {
        throw new AssertionError((Object)"This method should be called on the peer context.");
    }

    @Override
    public void afterRequest(long requestStartTimestamp, @Nullable Boolean retriableError) {
        throw new AssertionError((Object)"This method should be called on the peer context.");
    }

    @Override
    public long peerRequestTimeoutMillis() {
        throw new AssertionError((Object)"This method should be called on the peer context.");
    }

    @Override
    public ThrottlingContextHolder peerContextHolder(String consistentId) {
        return this.peerContexts.computeIfAbsent(consistentId, k -> new PeerContextHolder(consistentId));
    }

    @Override
    public void onNodeLeft(String consistentId) {
        this.peerContexts.remove(consistentId);
    }

    private class PeerContextHolder
    implements ThrottlingContextHolder {
        private static final double INCREASE_MULTIPLIER = 2.0;
        private static final double DECREASE_MULTIPLIER = 0.99;
        private static final int HISTOGRAM_WINDOW_SIZE = 1000;
        private static final double HISTOGRAM_PERCENTILE = 0.98;
        private static final double HISTOGRAM_PERCENTILE_INC_TIMEOUT_THRESHOLD = 0.5;
        private static final long HISTOGRAM_ESTIMATION_DEFAULT = 0L;
        private final SlidingHistogram histogram = new SlidingHistogram(1000, 0L);
        private final String consistentId;
        private final long decreaseDelay;
        private final LongAdder currentInFlights = new LongAdder();
        private final AtomicLong adaptiveResponseTimeoutMillis;
        private volatile long lastDecreaseTime = System.currentTimeMillis();

        PeerContextHolder(String consistentId) {
            this.consistentId = consistentId;
            int numberOfIterationsToReturnToDefault = (int)(-Math.log(2.0) / Math.log(0.99));
            this.decreaseDelay = 2L * (Long)ThrottlingContextHolderImpl.this.configuration.retryTimeoutMillis().value() / (long)numberOfIterationsToReturnToDefault;
            this.adaptiveResponseTimeoutMillis = new AtomicLong((Long)ThrottlingContextHolderImpl.this.configuration.responseTimeoutMillis().value());
        }

        @Override
        public boolean isOverloaded() {
            return (double)this.currentInFlights.longValue() >= (double)this.computeMaxInFlights() * ThrottlingContextHolderImpl.this.maxInflightOverflowRate;
        }

        int computeMaxInFlights() {
            long timeForMostOfRequests = this.histogram.estimatePercentile(0.98);
            return timeForMostOfRequests == 0L ? Integer.MAX_VALUE : (int)Math.max((double)this.adaptiveResponseTimeoutMillis.get() / (double)timeForMostOfRequests, 1.0);
        }

        @Override
        public void beforeRequest() {
            this.currentInFlights.increment();
        }

        @Override
        public void afterRequest(long requestStartTimestamp, Boolean retriableError) {
            this.currentInFlights.decrement();
            if (retriableError == null || retriableError.booleanValue()) {
                long now = System.currentTimeMillis();
                long duration = now - requestStartTimestamp;
                this.histogram.record(duration);
                boolean timedOut = retriableError != null;
                this.adaptRequestTimeout(now, timedOut);
            }
        }

        @Override
        public long peerRequestTimeoutMillis() {
            return this.adaptiveResponseTimeoutMillis.get();
        }

        @Override
        public ThrottlingContextHolder peerContextHolder(String consistentId) {
            return this;
        }

        @Override
        public void onNodeLeft(String consistentId) {
        }

        private void adaptRequestTimeout(long now, boolean timedOut) {
            double avg = this.histogram.estimatePercentile(0.5);
            long defaultResponseTimeout = (Long)ThrottlingContextHolderImpl.this.configuration.responseTimeoutMillis().value();
            long retryTimeout = (Long)ThrottlingContextHolderImpl.this.configuration.retryTimeoutMillis().value();
            long r = this.adaptiveResponseTimeoutMillis.get();
            if (now - this.lastDecreaseTime > this.decreaseDelay && avg < (double)r * 0.3 && r > (Long)ThrottlingContextHolderImpl.this.configuration.responseTimeoutMillis().value() && this.adaptiveResponseTimeoutMillis.compareAndSet(r, (long)Math.max((double)defaultResponseTimeout, (double)r * 0.99))) {
                LOG.debug("Adaptive response timeout changed [peer={}, action={}, from={}, to={}, avg={}].", this.consistentId, "DECREMENTED", r, this.adaptiveResponseTimeoutMillis.get(), avg);
                this.lastDecreaseTime = now;
            }
            long newTimeout = (long)Math.min((double)retryTimeout, (double)r * 2.0);
            while ((r = this.adaptiveResponseTimeoutMillis.get()) < retryTimeout && (avg >= (double)r * 0.7 || timedOut)) {
                if (!this.adaptiveResponseTimeoutMillis.compareAndSet(r, newTimeout)) continue;
                LOG.debug("Adaptive response timeout changed [peer={}, action={}, from={}, to={}, avg={}, timedOut={}].", this.consistentId, "INCREMENTED", r, this.adaptiveResponseTimeoutMillis.get(), avg, timedOut);
                break;
            }
        }
    }
}

