/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class InsertRecord<L>
extends PageDeltaRecord {
    private int idx;
    private byte[] rowBytes;
    @GridToStringExclude
    private long rightId;
    private BPlusIO<L> io;

    public InsertRecord(int grpId, long pageId, BPlusIO<L> io, int idx, byte[] rowBytes, long rightId) {
        super(grpId, pageId);
        this.io = io;
        this.idx = idx;
        this.rowBytes = rowBytes;
        this.rightId = rightId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        this.io.insert(pageAddr, this.idx, null, this.rowBytes, this.rightId, false);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_PAGE_INSERT;
    }

    public BPlusIO<L> io() {
        return this.io;
    }

    public int index() {
        return this.idx;
    }

    public long rightId() {
        return this.rightId;
    }

    public byte[] rowBytes() {
        return this.rowBytes;
    }

    @Override
    public String toString() {
        return S.toString(InsertRecord.class, this, "rightId", (Object)U.hexLong(this.rightId), "super", (Object)super.toString());
    }
}

