/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.Tracing;

public abstract class TraceRunnable
implements Runnable {
    private final Tracing tracing;
    private final SpanType spanType;
    private final Span parent;

    protected TraceRunnable(Tracing tracing, SpanType spanType) {
        this.tracing = tracing;
        this.spanType = spanType;
        this.parent = MTC.span();
    }

    @Override
    public void run() {
        Span span = this.tracing.create(this.spanType, this.parent);
        try (MTC.TraceSurroundings ignore = MTC.support(span.equals(NoopSpan.INSTANCE) ? this.parent : span);){
            this.execute();
        }
    }

    public abstract void execute();
}

