/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NumericInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.ShortIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class ShortInlineIndexKeyType
extends NumericInlineIndexKeyType<ShortIndexKey> {
    public ShortInlineIndexKeyType() {
        super(IndexKeyType.SHORT, (short)2);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        short val = PageUtils.getShort(pageAddr, off + 1);
        return -Integer.signum(((NumericIndexKey)key).compareTo(val));
    }

    @Override
    protected int put0(long pageAddr, int off, ShortIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putShort(pageAddr, off + 1, (Short)key.key());
        return this.keySize + 1;
    }

    @Override
    protected ShortIndexKey get0(long pageAddr, int off) {
        short key = PageUtils.getShort(pageAddr, off + 1);
        return new ShortIndexKey(key);
    }
}

