/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.metastore.status.ClusterStatusKey;

public class DownloadTracker {
    private final Map<ClusterStatusKey, CompletableFuture<?>> inFlightFutures = new ConcurrentHashMap();

    public <T> CompletableFuture<T> track(String id, Version version, Supplier<CompletableFuture<T>> trackableAction) {
        ClusterStatusKey key = ClusterStatusKey.builder().id(id).version(version).build();
        return this.inFlightFutures.computeIfAbsent(key, k -> ((CompletableFuture)trackableAction.get()).whenComplete((result, throwable) -> this.inFlightFutures.remove(key)));
    }

    public void cancelIfDownloading(String id, Version version) {
        ClusterStatusKey key = ClusterStatusKey.builder().id(id).version(version).build();
        CompletableFuture<?> future = this.inFlightFutures.remove(key);
        if (future != null) {
            future.cancel(true);
        }
    }

    public void cancelAll() {
        this.inFlightFutures.values().forEach(future -> future.cancel(true));
    }
}

