/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.treesitter.highlighter;

import java.util.Map;
import org.apache.ignite.internal.cli.commands.treesitter.parser.Indexer;
import org.apache.ignite.internal.cli.commands.treesitter.parser.JsonTokenType;
import org.apache.ignite.internal.cli.commands.treesitter.parser.Parser;
import org.apache.ignite.internal.cli.core.style.AnsiStringSupport;
import org.treesitter.TSTree;

public class JsonAnsiHighlighter {
    private static final Map<JsonTokenType, AnsiStringSupport.Color> colorMap = Map.of(JsonTokenType.QUOTE, AnsiStringSupport.Color.GREEN, JsonTokenType.STRING_CONTENT, AnsiStringSupport.Color.GREEN, JsonTokenType.BRACKET, AnsiStringSupport.Color.WHITE, JsonTokenType.COMMA, AnsiStringSupport.Color.WHITE, JsonTokenType.COLON, AnsiStringSupport.Color.WHITE, JsonTokenType.NUMBER, AnsiStringSupport.Color.BLUE, JsonTokenType.BOOL, AnsiStringSupport.Color.YELLOW_DARK, JsonTokenType.UNKNOWN, AnsiStringSupport.Color.GRAY, JsonTokenType.SPACE, AnsiStringSupport.Color.GRAY);

    public static String highlight(String text) {
        TSTree tree = Parser.parseJson(text);
        JsonTokenType[] tokens = Indexer.indexJson(text, tree);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            JsonTokenType token = tokens[i];
            AnsiStringSupport.Color color = colorMap.get((Object)token);
            sb.append(AnsiStringSupport.fg(color).mark(String.valueOf(text.charAt(i))));
        }
        return AnsiStringSupport.ansi(sb.toString());
    }
}

