/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLambda;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.ArrayElementOperandTypeChecker;
import org.apache.calcite.sql.type.ArrayInsertOperandTypeChecker;
import org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.CompositeSingleOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.FunctionSqlType;
import org.apache.calcite.sql.type.ImplicitCastOperandTypeChecker;
import org.apache.calcite.sql.type.IntervalOperandTypeChecker;
import org.apache.calcite.sql.type.LiteralOperandTypeChecker;
import org.apache.calcite.sql.type.MultisetOperandTypeChecker;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.NotNullOperandTypeChecker;
import org.apache.calcite.sql.type.OperandMetadataImpl;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SameOperandTypeExceptLastOperandChecker;
import org.apache.calcite.sql.type.SetopOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.validate.SqlLambdaScope;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.AbstractTypeCoercion;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class OperandTypes {
    public static final SqlSingleOperandTypeChecker NILADIC = OperandTypes.family(new SqlTypeFamily[0]);
    public static final SqlOperandTypeChecker VARIADIC = OperandTypes.variadic(SqlOperandCountRanges.any());
    public static final SqlOperandTypeChecker ONE_OR_MORE = OperandTypes.variadic(SqlOperandCountRanges.from(1));
    public static final SqlSingleOperandTypeChecker BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker BOOLEAN_BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker INTEGER = OperandTypes.family(SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker INTEGER_INTEGER = OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker VARIANT = OperandTypes.family(SqlTypeFamily.VARIANT);
    public static final SqlSingleOperandTypeChecker NUMERIC_NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker NUMERIC_OPTIONAL_NUMERIC = NUMERIC.or(NUMERIC_NUMERIC);
    public static final SqlSingleOperandTypeChecker NUMERIC_INTEGER = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker NUMERIC_OPTIONAL_INTEGER = NUMERIC.or(NUMERIC_INTEGER);
    public static final SqlOperandTypeChecker NUMERIC_INT32 = OperandTypes.sequence((SqlOperator operator, String name) -> operator.getName() + "(<NUMERIC>, <INTEGER>)", OperandTypes.family(SqlTypeFamily.NUMERIC), new TypeNameChecker(SqlTypeName.INTEGER));
    public static final SqlSingleOperandTypeChecker NUMERIC_CHARACTER = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC_EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker BINARY = OperandTypes.family(SqlTypeFamily.BINARY);
    public static final SqlSingleOperandTypeChecker BINARY_BINARY = OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.BINARY);
    public static final SqlSingleOperandTypeChecker STRING = OperandTypes.family(SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final SqlSingleOperandTypeChecker STRING_OPTIONAL_STRING = STRING.or(STRING_STRING);
    public static final FamilyOperandTypeChecker STRING_STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final SqlSingleOperandTypeChecker STRING_STRING_OPTIONAL_STRING = STRING_STRING.or(STRING_STRING_STRING);
    public static final SqlSingleOperandTypeChecker STRING_OPTIONAL_STRING_OPTIONAL_STRING = STRING.or(STRING_STRING).or(STRING_STRING_STRING);
    public static final FamilyOperandTypeChecker STRING_STRING_STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final SqlSingleOperandTypeChecker STRING_NUMERIC = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC);
    static final SqlSingleOperandTypeChecker STRING_NUMERIC_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING);
    public static final SqlSingleOperandTypeChecker STRING_NUMERIC_OPTIONAL_STRING = STRING_NUMERIC.or(STRING_NUMERIC_STRING);
    public static final SqlSingleOperandTypeChecker CHARACTER = OperandTypes.family(SqlTypeFamily.CHARACTER);
    public static final SqlSingleOperandTypeChecker DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker DATE = OperandTypes.family(SqlTypeFamily.DATE);
    public static final SqlSingleOperandTypeChecker TIME = OperandTypes.family(SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker TIMESTAMP = OperandTypes.family(SqlTypeFamily.TIMESTAMP);
    public static final SqlSingleOperandTypeChecker DATE_OR_TIMESTAMP = DATE.or(TIMESTAMP);
    public static final SqlSingleOperandTypeChecker TIMESTAMP_LTZ = new TypeNameChecker(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    public static final SqlSingleOperandTypeChecker TIMESTAMP_NTZ = new TypeNameChecker(SqlTypeName.TIMESTAMP);
    public static final SqlSingleOperandTypeChecker INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker CHARACTER_CHARACTER = OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER);
    public static final SqlSingleOperandTypeChecker CHARACTER_CHARACTER_DATETIME = OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker CHARACTER_DATE = OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.DATE);
    public static final SqlSingleOperandTypeChecker CHARACTER_TIME = OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker PERIOD = new PeriodOperandTypeChecker();
    public static final SqlSingleOperandTypeChecker PERIOD_OR_DATETIME = PERIOD.or(DATETIME);
    public static final FamilyOperandTypeChecker INTERVAL_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker MULTISET = OperandTypes.family(SqlTypeFamily.MULTISET);
    public static final SqlSingleOperandTypeChecker ARRAY = OperandTypes.family(SqlTypeFamily.ARRAY);
    public static final SqlSingleOperandTypeChecker ARRAY_ARRAY = OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY);
    public static final SqlSingleOperandTypeChecker ARRAY_OR_MAP = OperandTypes.family(SqlTypeFamily.ARRAY).or(OperandTypes.family(SqlTypeFamily.MAP)).or(OperandTypes.family(SqlTypeFamily.ANY));
    public static final SqlSingleOperandTypeChecker ARRAY_OR_MAP_OR_VARIANT = OperandTypes.family(SqlTypeFamily.ARRAY).or(OperandTypes.family(SqlTypeFamily.MAP)).or(OperandTypes.family(SqlTypeFamily.VARIANT)).or(OperandTypes.family(SqlTypeFamily.ANY));
    public static final SqlOperandTypeChecker STRING_ARRAY_CHARACTER_OPTIONAL_CHARACTER = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER), i -> i == 2){

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
                return false;
            }
            RelDataType elementType = callBinding.getOperandType(0).getComponentType();
            if (elementType == null || !SqlTypeUtil.isString(elementType)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
            return true;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + "(<STRING ARRAY>, <CHARACTER>[, <CHARACTER>])";
        }
    };
    public static final SqlSingleOperandTypeChecker ARRAY_OF_INTEGER = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (!super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure)) {
                return false;
            }
            RelDataType type = SqlTypeUtil.deriveType(callBinding, operand);
            if (SqlTypeUtil.isNull(type)) {
                return true;
            }
            RelDataType componentType = Objects.requireNonNull(type.getComponentType(), "componentType");
            if (SqlTypeUtil.isIntType(componentType) || SqlTypeUtil.isNull(componentType)) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + "(<INTEGER ARRAY>)";
        }
    };
    public static final SqlOperandTypeChecker STRING_FIRST_OBJECT_REPEAT = new StringFirstAndRepeatOperandTypeChecker(SqlOperandCountRanges.from(2), "(<STRING>(,<ANY>)+)"){

        @Override
        public boolean checkRepeatOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < callBinding.getOperandCount(); ++i) {
                RelDataType operandType;
                TypeCoercion coercion = callBinding.getValidator().getTypeCoercion();
                RelDataType cast = ((AbstractTypeCoercion)coercion).implicitCast(operandType = callBinding.getOperandType(i), SqlTypeFamily.STRING);
                SqlTypeFamily family = cast != null ? SqlTypeFamily.STRING : operandType.getSqlTypeName().getFamily();
                Objects.requireNonNull(family, "family");
                builder.add((Object)family);
            }
            ImmutableList families = builder.build();
            return OperandTypes.family((List<SqlTypeFamily>)families).checkOperandTypes(callBinding, throwOnFailure);
        }
    };
    public static final SqlOperandTypeChecker STRING_FIRST_STRING_ARRAY_REPEAT = new StringFirstAndRepeatOperandTypeChecker(SqlOperandCountRanges.from(1), "(<STRING>[,<STRING> | ARRAY<STRING>]+)"){

        @Override
        public boolean checkRepeatOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!this.checkArrayString(callBinding, throwOnFailure)) {
                return false;
            }
            return this.checkFamilyOperandTypes(callBinding, throwOnFailure);
        }

        private boolean checkFamilyOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < callBinding.getOperandCount(); ++i) {
                boolean isArray = callBinding.getOperandType(i).getSqlTypeName() == SqlTypeName.ARRAY;
                SqlTypeFamily family = isArray ? SqlTypeFamily.ARRAY : SqlTypeFamily.STRING;
                builder.add((Object)family);
            }
            ImmutableList families = builder.build();
            return OperandTypes.family((List<SqlTypeFamily>)families).checkOperandTypes(callBinding, throwOnFailure);
        }

        private boolean checkArrayString(SqlCallBinding binding, boolean throwOnFailure) {
            for (int i = 0; i < binding.getOperandCount(); ++i) {
                boolean isString;
                RelDataType type = binding.getOperandType(i);
                RelDataType componentType = type.getComponentType();
                boolean bl = isString = componentType != null && (SqlTypeUtil.isNull(componentType) || SqlTypeUtil.isString(componentType));
                if (type.getSqlTypeName() != SqlTypeName.ARRAY || isString) continue;
                if (throwOnFailure) {
                    throw binding.newValidationSignatureError();
                }
                return false;
            }
            return true;
        }
    };
    public static final SqlSingleOperandTypeChecker COLLECTION = OperandTypes.family(SqlTypeFamily.MULTISET).or(OperandTypes.family(SqlTypeFamily.ARRAY));
    public static final SqlSingleOperandTypeChecker COLLECTION_OR_MAP = OperandTypes.family(SqlTypeFamily.MULTISET).or(OperandTypes.family(SqlTypeFamily.ARRAY)).or(OperandTypes.family(SqlTypeFamily.MAP));
    public static final SqlSingleOperandTypeChecker MAP = OperandTypes.family(SqlTypeFamily.MAP);
    public static final SqlOperandTypeChecker ARRAY_FUNCTION = new ArrayFunctionOperandTypeChecker();
    public static final SqlOperandTypeChecker ARRAY_ELEMENT = new ArrayElementOperandTypeChecker(true, true);
    public static final SqlOperandTypeChecker ARRAY_ELEMENT_NONNULL = new ArrayElementOperandTypeChecker(false, true);
    public static final SqlOperandTypeChecker ARRAY_NONNULL = OperandTypes.family(SqlTypeFamily.ARRAY).and(new NotNullOperandTypeChecker(1, false));
    public static final SqlOperandTypeChecker ARRAY_INSERT = new ArrayInsertOperandTypeChecker();
    public static final SqlSingleOperandTypeChecker MAP_FROM_ENTRIES = new MapFromEntriesOperandTypeChecker();
    public static final SqlSingleOperandTypeChecker MAP_FUNCTION = new MapFunctionOperandTypeChecker();
    public static final SqlOperandTypeChecker MAP_KEY = new MapKeyOperandTypeChecker();
    public static final SqlSingleOperandTypeChecker NULLABLE_LITERAL = new LiteralOperandTypeChecker(true);
    public static final SqlSingleOperandTypeChecker LITERAL = new LiteralOperandTypeChecker(false);
    public static final SqlSingleOperandTypeChecker NONNULL_NONNULL = new NotNullOperandTypeChecker(2, false);
    public static final SqlSingleOperandTypeChecker BOOLEAN_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.BOOLEAN), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, operand, iFormalOperand, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = (SqlLiteral)operand;
            boolean isBooleanLiteral = SqlLiteral.valueMatchesType(arg.getValue(), SqlTypeName.BOOLEAN);
            if (!isBooleanLiteral) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBeBooleanLiteral(callBinding.getOperator().getName()));
                }
                return false;
            }
            return true;
        }
    };
    public static final SqlSingleOperandTypeChecker ARRAY_BOOLEAN_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.BOOLEAN), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (iFormalOperand == 0) {
                return super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure);
            }
            return BOOLEAN_LITERAL.checkSingleOperandType(callBinding, operand, iFormalOperand, throwOnFailure);
        }
    };
    public static final SqlSingleOperandTypeChecker POSITIVE_INTEGER_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, operand, iFormalOperand, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = (SqlLiteral)operand;
            BigDecimal value = arg.getValueAs(BigDecimal.class);
            if (value.compareTo(BigDecimal.ZERO) < 0 || this.hasFractionalPart(value)) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBePositiveInteger(callBinding.getOperator().getName()));
                }
                return false;
            }
            if (value.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.numberLiteralOutOfRange(value.toString()));
                }
                return false;
            }
            return true;
        }

        private boolean hasFractionalPart(BigDecimal bd) {
            return bd.precision() - bd.scale() <= 0;
        }
    };
    public static final SqlSingleOperandTypeChecker UNIT_INTERVAL_NUMERIC_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, operand, 0, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = (SqlLiteral)operand;
            BigDecimal value = arg.getValueAs(BigDecimal.class);
            if (value.compareTo(BigDecimal.ZERO) < 0 || value.compareTo(BigDecimal.ONE) > 0) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBeNumericLiteralInRange(callBinding.getOperator().getName(), 0, 1));
                }
                return false;
            }
            return true;
        }
    };
    public static final SqlSingleOperandTypeChecker NUMERIC_UNIT_INTERVAL_NUMERIC_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (iFormalOperand == 0) {
                return super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure);
            }
            return UNIT_INTERVAL_NUMERIC_LITERAL.checkSingleOperandType(callBinding, operand, iFormalOperand, throwOnFailure);
        }
    };
    public static final SqlSingleOperandTypeChecker SAME_SAME = new SameOperandTypeChecker(2);
    public static final SqlSingleOperandTypeChecker SAME_SAME_INTEGER = new SameOperandTypeExceptLastOperandChecker(3, "INTEGER");
    public static final SqlSingleOperandTypeChecker SAME_SAME_SAME = new SameOperandTypeChecker(3);
    public static final SqlOperandTypeChecker SAME_VARIADIC = new SameOperandTypeChecker(-1);
    public static final SqlOperandTypeChecker AT_LEAST_ONE_SAME_VARIADIC = new SameOperandTypeChecker(-1){

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.from(1);
        }
    };
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED_COMPARABLE_ORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.COMPARE);
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED = new ComparableOperandTypeChecker(1, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.NONE);
    public static final SqlOperandTypeChecker COMPARABLE_UNORDERED_COMPARABLE_UNORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.UNORDERED, SqlOperandTypeChecker.Consistency.LEAST_RESTRICTIVE);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME = STRING_STRING.and(SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_SAME = STRING_STRING_STRING.and(SAME_SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_STRING_OPTIONAL_INTEGER_OPTIONAL_INTEGER = STRING_STRING.or(STRING_STRING_INTEGER).or(STRING_STRING_INTEGER_INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER_INTEGER_INTEGER = OperandTypes.family((List<SqlTypeFamily>)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER));
    public static final SqlSingleOperandTypeChecker STRING_STRING_OPTIONAL_INTEGER_OPTIONAL_INTEGER_OPTIONAL_INTEGER = STRING_STRING.or(STRING_STRING_INTEGER).or(STRING_STRING_INTEGER_INTEGER).or(STRING_STRING_INTEGER_INTEGER_INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_INTEGER_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_INTEGER_OPTIONAL_INTEGER = STRING_INTEGER.or(STRING_INTEGER_INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_NUMERIC_NUMERIC = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker CBSTRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER).or(OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.INTEGER));
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_INTEGER = STRING_STRING_INTEGER.and(SAME_SAME_INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_OR_ARRAY_SAME_SAME = OperandTypes.or(STRING_SAME_SAME, OperandTypes.and(SAME_SAME, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY)));
    public static final SqlSingleOperandTypeChecker ANY = OperandTypes.family(SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_ANY = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker SECOND_THIRD_SAME = new SameOperandTypeChecker(3){

        @Override
        protected List<Integer> getOperandList(int operandCount) {
            return ImmutableList.of((Object)1, (Object)2);
        }
    };
    public static final SqlSingleOperandTypeChecker ANY_IGNORE = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.IGNORE);
    public static final SqlSingleOperandTypeChecker IGNORE_ANY = OperandTypes.family(SqlTypeFamily.IGNORE, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_NUMERIC = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker ANY_NUMERIC_ANY = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_STRING_STRING = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final SqlSingleOperandTypeChecker ANY_STRING_OPTIONAL_STRING = OperandTypes.family((List<SqlTypeFamily>)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.STRING)).or(ANY_STRING_STRING);
    public static final SqlOperandTypeChecker ANY_COMPARABLE = new SqlOperandTypeChecker(){

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            this.getOperandCountRange().isValidCount(callBinding.getOperandCount());
            RelDataType type = callBinding.getOperandType(1);
            return type.getComparability() == RelDataTypeComparability.ALL;
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(2);
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + "(<ANY>, <COMPARABLE_TYPE>)";
        }
    };
    public static final SqlSingleOperandTypeChecker CURSOR = OperandTypes.family(SqlTypeFamily.CURSOR);
    public static final SqlSingleOperandTypeChecker MEASURE = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.ANY), i -> false){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, SqlTypeFamily family, boolean throwOnFailure) {
            if (!super.checkSingleOperandType(callBinding, operand, iFormalOperand, family, throwOnFailure)) {
                return false;
            }
            SqlValidatorScope scope = callBinding.getScope();
            if (!scope.isMeasureRef(operand)) {
                if (throwOnFailure) {
                    throw callBinding.newValidationError(Static.RESOURCE.argumentMustBeMeasure(callBinding.getOperator().getName()));
                }
                return false;
            }
            return true;
        }
    };
    public static final SqlOperandTypeChecker MEASURE_BOOLEAN = OperandTypes.sequence("'<MEASURE>, <BOOLEAN>'", MEASURE, BOOLEAN);
    public static final SqlSingleOperandTypeChecker INTERVAL_SAME_SAME = INTERVAL_INTERVAL.and(SAME_SAME);
    public static final SqlSingleOperandTypeChecker NUMERIC_INTERVAL = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker INTERVAL_NUMERIC = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker TIME_INTERVAL = OperandTypes.family(SqlTypeFamily.TIME, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker TIMESTAMP_INTERVAL = OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATE_INTERVAL = OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATE_ANY = OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker DATE_CHARACTER = OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.CHARACTER);
    public static final SqlSingleOperandTypeChecker DATE_TIME = OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker TIMESTAMP_STRING = OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.STRING);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_INTERVAL_TIME = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL_TIME = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.TIME);
    public static final SqlSingleOperandTypeChecker INTERVAL_DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker INTERVALINTERVAL_INTERVALDATETIME = INTERVAL_SAME_SAME.or(INTERVAL_DATETIME).or(OperandTypes.family(SqlTypeFamily.INTERVAL_DAY_TIME, SqlTypeFamily.INTERVAL_YEAR_MONTH));
    public static final SqlSingleOperandTypeChecker PLUS_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_SAME_SAME).or(DATETIME_INTERVAL).or(INTERVAL_DATETIME);
    public static final SqlSingleOperandTypeChecker MULTIPLY_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_NUMERIC).or(NUMERIC_INTERVAL);
    public static final SqlSingleOperandTypeChecker DIVISION_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_NUMERIC);
    public static final SqlSingleOperandTypeChecker MINUS_OPERATOR = NUMERIC_NUMERIC.or(INTERVAL_SAME_SAME).or(DATETIME_INTERVAL);
    public static final FamilyOperandTypeChecker MINUS_DATE_OPERATOR = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.DATETIME_INTERVAL), i -> false){

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
                return false;
            }
            return SAME_SAME.checkOperandTypes(callBinding, throwOnFailure);
        }

        @Override
        public boolean checkOperandTypesWithoutTypeCoercion(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!super.checkOperandTypesWithoutTypeCoercion(callBinding, throwOnFailure)) {
                return false;
            }
            return SAME_SAME.checkOperandTypes(callBinding, throwOnFailure);
        }
    };
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_INTERVAL = NUMERIC.or(INTERVAL);
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_STRING = NUMERIC.or(STRING);
    public static final SqlSingleOperandTypeChecker RECORD_COLLECTION = new RecordTypeWithOneFieldChecker(sqlTypeName -> sqlTypeName != SqlTypeName.ARRAY && sqlTypeName != SqlTypeName.MULTISET){

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "UNNEST(<MULTISET>)";
        }
    };
    public static final SqlOperandTypeChecker EXISTS = new SqlOperandTypeChecker(){

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            ARRAY.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
            RelDataType arrayType = SqlTypeUtil.deriveType(callBinding, callBinding.operand(0));
            RelDataType componentType = Objects.requireNonNull(arrayType.getComponentType(), "componentType");
            LambdaRelOperandTypeChecker lambdaChecker = new LambdaRelOperandTypeChecker(SqlTypeFamily.BOOLEAN, (List<RelDataType>)ImmutableList.of((Object)componentType));
            return lambdaChecker.checkSingleOperandType(callBinding, callBinding.operand(1), 1, throwOnFailure);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(2);
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "EXISTS(<ARRAY>, <FUNCTION(ARRAY_ELEMENT_TYPE)->BOOLEAN>)";
        }
    };
    public static final SqlSingleOperandTypeChecker SCALAR_OR_RECORD_COLLECTION = COLLECTION.or(RECORD_COLLECTION);
    public static final SqlSingleOperandTypeChecker SCALAR_OR_RECORD_COLLECTION_OR_MAP = COLLECTION_OR_MAP.or(new RecordTypeWithOneFieldChecker(sqlTypeName -> sqlTypeName != SqlTypeName.MULTISET && sqlTypeName != SqlTypeName.ARRAY && sqlTypeName != SqlTypeName.MAP){

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "UNNEST(<MULTISET>)\nUNNEST(<ARRAY>)\nUNNEST(<MAP>)";
        }
    });
    public static final SqlOperandTypeChecker MULTISET_MULTISET = new MultisetOperandTypeChecker();
    public static final SqlOperandTypeChecker SET_OP = new SetopOperandTypeChecker();
    public static final SqlOperandTypeChecker RECORD_TO_SCALAR = new SqlSingleOperandTypeChecker(){

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of((Object)"RECORDTYPE(SINGLE FIELD)"));
        }
    };

    private OperandTypes() {
    }

    public static FamilyOperandTypeChecker family(SqlTypeFamily ... families) {
        return new FamilyOperandTypeChecker((List<SqlTypeFamily>)ImmutableList.copyOf((Object[])families), i -> false);
    }

    public static FamilyOperandTypeChecker family(List<SqlTypeFamily> families, Predicate<Integer> optional) {
        return new FamilyOperandTypeChecker(families, optional);
    }

    public static FamilyOperandTypeChecker family(List<SqlTypeFamily> families) {
        return OperandTypes.family(families, (Integer i) -> false);
    }

    public static SqlSingleOperandTypeChecker function(SqlTypeFamily returnTypeFamily, SqlTypeFamily ... paramTypeFamilies) {
        return new LambdaFamilyOperandTypeChecker(returnTypeFamily, (List<SqlTypeFamily>)ImmutableList.copyOf((Object[])paramTypeFamilies));
    }

    public static SqlSingleOperandTypeChecker function(SqlTypeFamily returnTypeFamily, List<SqlTypeFamily> paramTypeFamilies) {
        return new LambdaFamilyOperandTypeChecker(returnTypeFamily, paramTypeFamilies);
    }

    public static SqlSingleOperandTypeChecker typeName(SqlTypeName typeName) {
        return new TypeNameChecker(typeName);
    }

    public static SqlSingleOperandTypeChecker interval(Iterable<TimeUnitRange> ranges) {
        ImmutableSet set = ImmutableSet.copyOf(ranges);
        return new IntervalOperandTypeChecker(arg_0 -> OperandTypes.lambda$interval$2((Set)set, arg_0));
    }

    public static SqlSingleOperandTypeChecker dateInterval() {
        return new IntervalOperandTypeChecker(SqlIntervalQualifier::isDate);
    }

    public static SqlSingleOperandTypeChecker timeInterval() {
        return new IntervalOperandTypeChecker(SqlIntervalQualifier::isTime);
    }

    public static SqlSingleOperandTypeChecker timestampInterval() {
        return new IntervalOperandTypeChecker(SqlIntervalQualifier::isTimestamp);
    }

    public static SqlOperandMetadata operandMetadata(List<SqlTypeFamily> families, Function<RelDataTypeFactory, List<RelDataType>> typesFactory, IntFunction<String> operandName, Predicate<Integer> optional) {
        return new OperandMetadataImpl(families, typesFactory, operandName, optional);
    }

    public static SqlOperandTypeChecker or(SqlOperandTypeChecker ... rules) {
        return OperandTypes.composite(CompositeOperandTypeChecker.Composition.OR, (List<? extends SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null, null, null);
    }

    public static SqlOperandTypeChecker and(SqlOperandTypeChecker ... rules) {
        return OperandTypes.and_((Iterable<SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules));
    }

    private static SqlOperandTypeChecker and_(Iterable<SqlOperandTypeChecker> rules) {
        return OperandTypes.composite(CompositeOperandTypeChecker.Composition.AND, (List<? extends SqlOperandTypeChecker>)ImmutableList.copyOf(rules), null, null, null);
    }

    public static SqlSingleOperandTypeChecker or(SqlSingleOperandTypeChecker ... rules) {
        return OperandTypes.compositeSingle(CompositeOperandTypeChecker.Composition.OR, (List<? extends SqlSingleOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null);
    }

    public static SqlSingleOperandTypeChecker and(SqlSingleOperandTypeChecker ... rules) {
        return OperandTypes.compositeSingle(CompositeOperandTypeChecker.Composition.AND, (List<? extends SqlSingleOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null);
    }

    private static SqlSingleOperandTypeChecker compositeSingle(CompositeOperandTypeChecker.Composition composition, List<? extends SqlSingleOperandTypeChecker> allowedRules, @Nullable String allowedSignatures) {
        ArrayList<? extends SqlSingleOperandTypeChecker> list = new ArrayList<SqlSingleOperandTypeChecker>(allowedRules);
        switch (composition) {
            default: {
                break;
            }
            case AND: 
            case OR: {
                OperandTypes.flatten(list, c -> c instanceof CompositeSingleOperandTypeChecker && ((CompositeSingleOperandTypeChecker)c).composition == composition ? ((CompositeSingleOperandTypeChecker)c).getRules() : null);
            }
        }
        if (list.size() == 1) {
            return (SqlSingleOperandTypeChecker)list.get(0);
        }
        return new CompositeSingleOperandTypeChecker(composition, (ImmutableList<? extends SqlSingleOperandTypeChecker>)ImmutableList.copyOf(list), allowedSignatures);
    }

    public static SqlOperandTypeChecker sequence(String allowedSignatures, SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.SEQUENCE, (ImmutableList<? extends SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), allowedSignatures, null, null);
    }

    public static SqlOperandTypeChecker sequence(BiFunction<SqlOperator, String, String> signatureGenerator, SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.SEQUENCE, (ImmutableList<? extends SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null, signatureGenerator, null);
    }

    public static SqlOperandTypeChecker repeat(SqlOperandCountRange range, SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.REPEAT, (ImmutableList<? extends SqlOperandTypeChecker>)ImmutableList.copyOf((Object[])rules), null, null, range);
    }

    public static SqlOperandTypeChecker nth(int ordinal, int operandCount, SqlSingleOperandTypeChecker rule) {
        Object[] rules = new SqlSingleOperandTypeChecker[operandCount];
        Arrays.fill(rules, ANY);
        rules[ordinal] = rule;
        return OperandTypes.sequence("", (SqlSingleOperandTypeChecker[])rules);
    }

    static SqlOperandTypeChecker composite(CompositeOperandTypeChecker.Composition composition, List<? extends SqlOperandTypeChecker> allowedRules, @Nullable String allowedSignatures, @Nullable BiFunction<SqlOperator, String, String> signatureGenerator, @Nullable SqlOperandCountRange range) {
        ArrayList<? extends SqlOperandTypeChecker> list = new ArrayList<SqlOperandTypeChecker>(allowedRules);
        switch (composition) {
            default: {
                break;
            }
            case AND: 
            case OR: {
                OperandTypes.flatten(list, c -> c instanceof CompositeOperandTypeChecker && ((CompositeOperandTypeChecker)c).composition == composition ? ((CompositeOperandTypeChecker)c).getRules() : null);
            }
        }
        if (list.size() == 1) {
            return (SqlOperandTypeChecker)list.get(0);
        }
        return new CompositeOperandTypeChecker(composition, (ImmutableList<? extends SqlOperandTypeChecker>)ImmutableList.copyOf(list), allowedSignatures, signatureGenerator, range);
    }

    private static <E> void flatten(List<E> list, Function<E, @Nullable List<? extends E>> expander) {
        int i = 0;
        while (i < list.size()) {
            @Nullable List<? extends E> list2 = expander.apply(list.get(i));
            if (list2 == null) {
                ++i;
                continue;
            }
            list.remove(i);
            list.addAll(i, list2);
        }
    }

    public static SqlOperandTypeChecker variadic(final SqlOperandCountRange range) {
        return new SqlOperandTypeChecker(){

            @Override
            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return range.isValidCount(callBinding.getOperandCount());
            }

            @Override
            public SqlOperandCountRange getOperandCountRange() {
                return range;
            }

            @Override
            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(...)";
            }
        };
    }

    public static SqlSingleOperandTypeChecker same(int operandCount, int ... ordinals) {
        final ImmutableIntList ordinalList = ImmutableIntList.of(ordinals);
        Preconditions.checkArgument((ordinalList.size() >= 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)Util.isDistinct(ordinalList));
        return new SameOperandTypeChecker(operandCount){

            @Override
            protected List<Integer> getOperandList(int operandCount) {
                return ordinalList;
            }
        };
    }

    private static /* synthetic */ boolean lambda$interval$2(Set set, SqlIntervalQualifier intervalQualifier) {
        return set.contains(intervalQualifier.timeUnitRange);
    }

    private static abstract class LambdaOperandTypeChecker
    implements SqlSingleOperandTypeChecker {
        protected final SqlTypeFamily returnTypeFamily;

        LambdaOperandTypeChecker(SqlTypeFamily returnTypeFamily) {
            this.returnTypeFamily = Objects.requireNonNull(returnTypeFamily, "returnTypeFamily");
        }

        protected boolean checkNull(SqlCallBinding callBinding, SqlLambda lambdaExpr, boolean throwOnFailure) {
            if (callBinding.isTypeCoercionEnabled()) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(lambdaExpr.getExpression(), Static.RESOURCE.nullIllegal());
            }
            return false;
        }

        protected boolean checkReturnType(SqlValidator validator, SqlCallBinding callBinding, SqlLambda lambdaExpr, boolean throwOnFailure) {
            RelDataType newType = validator.getValidatedNodeType(lambdaExpr);
            assert (newType instanceof FunctionSqlType);
            SqlTypeName returnTypeName = ((FunctionSqlType)newType).getReturnType().getSqlTypeName();
            if (returnTypeName == SqlTypeName.ANY || this.returnTypeFamily.getTypeNames().contains((Object)returnTypeName)) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }

        protected static class TypeRemover
        extends SqlBasicVisitor<Void> {
            private final SqlValidator validator;

            protected TypeRemover(SqlValidator validator) {
                this.validator = validator;
            }

            @Override
            public Void visit(SqlIdentifier id) {
                this.validator.removeValidatedNodeType(id);
                return (Void)super.visit(id);
            }

            @Override
            public Void visit(SqlCall call) {
                this.validator.removeValidatedNodeType(call);
                return (Void)super.visit(call);
            }
        }
    }

    private static class LambdaRelOperandTypeChecker
    extends LambdaOperandTypeChecker {
        private final List<RelDataType> argTypes;

        LambdaRelOperandTypeChecker(SqlTypeFamily returnTypeFamily, List<RelDataType> argTypes) {
            super(returnTypeFamily);
            this.argTypes = argTypes;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.argTypes.stream().map(t -> Objects.requireNonNull(t.getSqlTypeName().getFamily())).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            builder.add((Object)this.returnTypeFamily);
            return SqlUtil.getAliasedSignature(op, opName, builder.build());
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
            if (!(operand instanceof SqlLambda) || ((SqlLambda)operand).getParameters().size() != this.argTypes.size()) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
            SqlLambda lambdaExpr = (SqlLambda)operand;
            if (SqlUtil.isNullLiteral(lambdaExpr.getExpression(), false)) {
                this.checkNull(callBinding, lambdaExpr, throwOnFailure);
            }
            SqlValidator validator = callBinding.getValidator();
            SqlLambdaScope scope = (SqlLambdaScope)validator.getLambdaScope(lambdaExpr);
            for (int i = 0; i < this.argTypes.size(); ++i) {
                SqlNode param = lambdaExpr.getParameters().get(i);
                RelDataType type = this.argTypes.get(i);
                if (type == null) continue;
                scope.getParameterTypes().put(param.toString(), type);
            }
            lambdaExpr.accept(new LambdaOperandTypeChecker.TypeRemover(validator));
            validator.validateLambda(lambdaExpr);
            return this.checkReturnType(validator, callBinding, lambdaExpr, throwOnFailure);
        }
    }

    private static class LambdaFamilyOperandTypeChecker
    extends LambdaOperandTypeChecker {
        private final List<SqlTypeFamily> argFamilies;

        LambdaFamilyOperandTypeChecker(SqlTypeFamily returnTypeFamily, List<SqlTypeFamily> argFamilies) {
            super(returnTypeFamily);
            this.argFamilies = ImmutableList.copyOf(argFamilies);
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.argFamilies);
            builder.add((Object)this.returnTypeFamily);
            return SqlUtil.getAliasedSignature(op, opName, builder.build());
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return false;
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
            if (!(operand instanceof SqlLambda) || ((SqlLambda)operand).getParameters().size() != this.argFamilies.size()) {
                if (throwOnFailure) {
                    throw callBinding.newValidationSignatureError();
                }
                return false;
            }
            SqlLambda lambdaExpr = (SqlLambda)operand;
            if (SqlUtil.isNullLiteral(lambdaExpr.getExpression(), false)) {
                this.checkNull(callBinding, lambdaExpr, throwOnFailure);
            }
            SqlValidator validator = callBinding.getValidator();
            if (!lambdaExpr.getParameters().isEmpty() && !this.argFamilies.stream().allMatch(f -> f == SqlTypeFamily.ANY)) {
                SqlLambdaScope scope = (SqlLambdaScope)validator.getLambdaScope(lambdaExpr);
                for (int i = 0; i < this.argFamilies.size(); ++i) {
                    SqlNode param = lambdaExpr.getParameters().get(i);
                    RelDataType type = this.argFamilies.get(i).getDefaultConcreteType(callBinding.getTypeFactory());
                    if (type == null) continue;
                    scope.getParameterTypes().put(param.toString(), type);
                }
                lambdaExpr.accept(new LambdaOperandTypeChecker.TypeRemover(validator));
                validator.validateLambda(lambdaExpr);
            }
            return this.checkReturnType(validator, callBinding, lambdaExpr, throwOnFailure);
        }
    }

    private static class TypeNameChecker
    implements SqlSingleOperandTypeChecker,
    ImplicitCastOperandTypeChecker {
        final SqlTypeName typeName;

        TypeNameChecker(SqlTypeName typeName) {
            this.typeName = Objects.requireNonNull(typeName, "typeName");
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
            RelDataType operandType = callBinding.getValidator().getValidatedNodeType(operand);
            return operandType.getSqlTypeName() == this.typeName;
        }

        @Override
        public boolean checkOperandTypesWithoutTypeCoercion(SqlCallBinding callBinding, boolean throwOnFailure) {
            return this.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
        }

        @Override
        public SqlTypeFamily getOperandSqlTypeFamily(int iFormalOperand) {
            return Objects.requireNonNull(this.typeName.getFamily(), "family");
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + "(" + this.typeName.getSpaceName() + ")";
        }
    }

    private static class MapKeyOperandTypeChecker
    extends SameOperandTypeChecker {
        MapKeyOperandTypeChecker() {
            super(2);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            SqlNode op0 = callBinding.operand(0);
            if (!MAP.checkSingleOperandType(callBinding, op0, 0, throwOnFailure)) {
                return false;
            }
            RelDataType mapKeyType = NonNullableAccessors.getKeyTypeOrThrow(SqlTypeUtil.deriveType(callBinding, op0));
            SqlNode op1 = callBinding.operand(1);
            RelDataType opType1 = SqlTypeUtil.deriveType(callBinding, op1);
            RelDataType biggest = callBinding.getTypeFactory().leastRestrictive((List<RelDataType>)ImmutableList.of((Object)mapKeyType, (Object)opType1));
            if (biggest == null) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.typeNotComparable(mapKeyType.toString(), opType1.toString()));
                }
                return false;
            }
            return true;
        }
    }

    private static class PeriodOperandTypeChecker
    implements SqlSingleOperandTypeChecker {
        private PeriodOperandTypeChecker() {
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean valid = false;
            if (type.isStruct() && type.getFieldList().size() == 2) {
                RelDataType t0 = type.getFieldList().get(0).getType();
                RelDataType t1 = type.getFieldList().get(1).getType();
                if (SqlTypeUtil.isDatetime(t0)) {
                    if (SqlTypeUtil.isDatetime(t1)) {
                        if (SqlTypeUtil.sameNamedType(t0, t1)) {
                            valid = true;
                        }
                    } else if (SqlTypeUtil.isInterval(t1)) {
                        valid = true;
                    }
                }
            }
            if (!valid && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return valid;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of((Object)"PERIOD (DATETIME, INTERVAL)", (Object)"PERIOD (DATETIME, DATETIME)"));
        }
    }

    private static class MapFunctionOperandTypeChecker
    extends SameOperandTypeChecker {
        MapFunctionOperandTypeChecker() {
            super(-1);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            List<RelDataType> argTypes = SqlTypeUtil.deriveType(callBinding, callBinding.operands());
            if (argTypes.isEmpty()) {
                return true;
            }
            if (argTypes.size() % 2 != 0) {
                throw callBinding.newValidationError(Static.RESOURCE.mapRequiresEvenArgCount());
            }
            Pair<@Nullable RelDataType, @Nullable RelDataType> componentType = MapFunctionOperandTypeChecker.getComponentTypes(callBinding.getTypeFactory(), argTypes);
            if (null == componentType.left || null == componentType.right) {
                if (throwOnFailure) {
                    throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
                }
                return false;
            }
            return true;
        }

        private static Pair<@Nullable RelDataType, @Nullable RelDataType> getComponentTypes(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
            return Pair.of(typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 0)), typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 1)));
        }
    }

    private static class ArrayFunctionOperandTypeChecker
    extends SameOperandTypeChecker {
        ArrayFunctionOperandTypeChecker() {
            super(-1);
        }

        @Override
        protected boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, @Nullable SqlCallBinding callBinding) {
            if (throwOnFailure && callBinding == null) {
                throw new IllegalArgumentException("callBinding must be non-null in case throwOnFailure=true");
            }
            int nOperandsActual = this.nOperands;
            if (nOperandsActual == -1) {
                nOperandsActual = operatorBinding.getOperandCount();
            }
            RelDataType[] types = new RelDataType[nOperandsActual];
            List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
            for (int i : operandList) {
                types[i] = operatorBinding.getOperandType(i);
            }
            for (int i : operandList) {
                RelDataType type;
                if (i <= 0 || (type = SqlTypeUtil.leastRestrictiveForComparison(operatorBinding.getTypeFactory(), types[i], types[i - 1])) != null) continue;
                if (!throwOnFailure) {
                    return false;
                }
                throw Objects.requireNonNull(callBinding, "callBinding").newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return true;
        }
    }

    private static class MapFromEntriesOperandTypeChecker
    implements SqlSingleOperandTypeChecker {
        private MapFromEntriesOperandTypeChecker() {
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            RelDataType componentType = Objects.requireNonNull(type.getComponentType(), "componentType");
            boolean valid = false;
            if (type.getSqlTypeName() == SqlTypeName.ARRAY && componentType.getSqlTypeName() == SqlTypeName.ROW && componentType.getFieldCount() == 2) {
                valid = true;
            }
            if (!valid && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return valid;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of((Object)"ARRAY<RECORDTYPE(TWO FIELDS)>"));
        }
    }

    private static abstract class RecordTypeWithOneFieldChecker
    implements SqlSingleOperandTypeChecker {
        private final Predicate<SqlTypeName> typeNamePredicate;

        private RecordTypeWithOneFieldChecker(Predicate<SqlTypeName> predicate) {
            this.typeNamePredicate = predicate;
        }

        @Override
        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = SqlTypeUtil.deriveType(callBinding, node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            } else {
                SqlTypeName typeName = type.getFieldList().get(0).getType().getSqlTypeName();
                if (this.typeNamePredicate.test(typeName)) {
                    validationError = true;
                }
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }
    }

    static abstract class StringFirstAndRepeatOperandTypeChecker
    implements SqlOperandTypeChecker {
        private final SqlOperandCountRange countRange;
        private final String signatures;

        StringFirstAndRepeatOperandTypeChecker(SqlOperandCountRange countRange, String signatures) {
            this.countRange = countRange;
            this.signatures = signatures;
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!STRING.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure)) {
                return false;
            }
            return this.checkRepeatOperandTypes(callBinding, throwOnFailure);
        }

        @Override
        public SqlOperandCountRange getOperandCountRange() {
            return this.countRange;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + this.signatures;
        }

        public abstract boolean checkRepeatOperandTypes(SqlCallBinding var1, boolean var2);
    }
}

