/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class IgniteNameUtils {
    private IgniteNameUtils() {
    }

    public static String parseIdentifier(String identifier) {
        IgniteNameUtils.ensureNotNullAndNotEmpty(identifier, "name");
        Tokenizer tokenizer = new Tokenizer(identifier);
        String parsedName = tokenizer.nextToken();
        if (tokenizer.hasNext()) {
            throw new IllegalArgumentException("Fully qualified name is not expected [name=" + identifier + "]");
        }
        return parsedName;
    }

    public static List<String> parseName(String name) {
        IgniteNameUtils.ensureNotNullAndNotEmpty(name, "name");
        ArrayList<String> identifiers = new ArrayList<String>(2);
        Tokenizer tokenizer = new Tokenizer(name);
        do {
            identifiers.add(tokenizer.nextToken());
        } while (tokenizer.hasNext());
        return identifiers;
    }

    public static String canonicalName(String schemaName, String objectName) {
        return IgniteNameUtils.quoteIfNeeded(schemaName) + "." + IgniteNameUtils.quoteIfNeeded(objectName);
    }

    public static String quoteIfNeeded(String identifier) {
        IgniteNameUtils.ensureNotNullAndNotEmpty(identifier, "identifier");
        int codePoint = identifier.codePointAt(0);
        if (!(codePoint == 95 || Character.isUpperCase(codePoint) && IgniteNameUtils.identifierStart(codePoint))) {
            return IgniteNameUtils.quote(identifier);
        }
        for (int pos = 1; pos < identifier.length(); ++pos) {
            codePoint = identifier.codePointAt(pos);
            if (Character.isUpperCase(codePoint) && IgniteNameUtils.identifierStart(codePoint) || IgniteNameUtils.identifierExtend(codePoint)) continue;
            return IgniteNameUtils.quote(identifier);
        }
        return identifier;
    }

    public static boolean isValidNormalizedIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        int codePoint = identifier.codePointAt(0);
        if (!IgniteNameUtils.identifierStart(codePoint)) {
            return false;
        }
        for (int pos = 1; pos < identifier.length(); ++pos) {
            codePoint = identifier.codePointAt(pos);
            if (IgniteNameUtils.identifierStart(codePoint) || IgniteNameUtils.identifierExtend(codePoint)) continue;
            return false;
        }
        return true;
    }

    private static boolean identifierStart(int codePoint) {
        return Character.isAlphabetic(codePoint) || codePoint == 95;
    }

    private static boolean identifierExtend(int codePoint) {
        return codePoint == 183 || (8454976 >> Character.getType(codePoint) & 1) != 0;
    }

    private static String quote(String name) {
        if (name.chars().noneMatch(cp -> cp == 34)) {
            return "\"" + name + "\"";
        }
        StringBuilder sb = new StringBuilder(name.length() + 2).append('\"');
        for (int currentPosition = 0; currentPosition < name.length(); ++currentPosition) {
            char ch = name.charAt(currentPosition);
            if (ch == '\"') {
                sb.append('\"');
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb.toString();
    }

    private static void ensureNotNullAndNotEmpty(@Nullable String argument, String argumentName) {
        Objects.requireNonNull(argument, "name");
        if (argument.isEmpty()) {
            throw new IllegalArgumentException("Argument \"" + argumentName + "\" can't be empty.");
        }
    }

    private static class Tokenizer {
        private final String source;
        private int currentPosition;
        private boolean foundDot;

        private Tokenizer(String source) {
            this.source = source;
        }

        private boolean hasNext() {
            return this.foundDot || !this.isEol();
        }

        private String nextToken() {
            boolean quoted;
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more tokens available.");
            }
            if (this.isEol()) {
                assert (this.foundDot);
                this.foundDot = false;
                return "";
            }
            boolean bl = quoted = this.currentChar() == '\"';
            if (quoted) {
                ++this.currentPosition;
            }
            int start = this.currentPosition;
            StringBuilder sb = new StringBuilder();
            this.foundDot = false;
            if (!quoted && !this.isEol()) {
                if (IgniteNameUtils.identifierStart(this.source.codePointAt(this.currentPosition))) {
                    ++this.currentPosition;
                } else {
                    this.throwMalformedIdentifierException();
                }
            }
            while (!this.isEol()) {
                char c = this.currentChar();
                if (c == '\"') {
                    if (!quoted) {
                        this.throwMalformedIdentifierException();
                    }
                    if (this.hasNextChar() && this.nextChar() == '\"') {
                        sb.append(this.source, start, this.currentPosition + 1);
                        start = this.currentPosition + 2;
                        ++this.currentPosition;
                    } else {
                        if (!this.hasNextChar() || this.nextChar() == '.') {
                            sb.append(this.source, start, this.currentPosition);
                            this.foundDot = this.hasNextChar();
                            this.currentPosition += 2;
                            return sb.toString();
                        }
                        this.throwMalformedIdentifierException();
                    }
                } else if (c == '.') {
                    if (!quoted) {
                        sb.append(this.source, start, this.currentPosition);
                        ++this.currentPosition;
                        this.foundDot = true;
                        return sb.toString().toUpperCase();
                    }
                } else if (!(quoted || IgniteNameUtils.identifierStart(this.source.codePointAt(this.currentPosition)) || IgniteNameUtils.identifierExtend(this.source.codePointAt(this.currentPosition)))) {
                    this.throwMalformedIdentifierException();
                }
                ++this.currentPosition;
            }
            if (quoted) {
                this.throwMalformedIdentifierException();
            }
            return this.source.substring(start).toUpperCase();
        }

        private boolean isEol() {
            return this.currentPosition >= this.source.length();
        }

        private char currentChar() {
            return this.source.charAt(this.currentPosition);
        }

        private boolean hasNextChar() {
            return this.currentPosition + 1 < this.source.length();
        }

        private char nextChar() {
            return this.source.charAt(this.currentPosition + 1);
        }

        private void throwMalformedIdentifierException() {
            throw new IllegalArgumentException("Malformed identifier [identifier=" + this.source + ", pos=" + this.currentPosition + "]");
        }
    }
}

