/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.RemoveIndexCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class RemoveIndexCommand
implements CatalogCommand {
    private final int indexId;

    public static RemoveIndexCommandBuilder builder() {
        return new Builder();
    }

    private RemoveIndexCommand(int indexId) {
        this.indexId = indexId;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(catalog, this.indexId);
        if (index.status() != CatalogIndexStatus.STOPPING) {
            throw new CatalogValidationException("Cannot remove index {} because its status is {}.", new Object[]{this.indexId, index.status()});
        }
        return List.of(new RemoveIndexEntry(this.indexId));
    }

    private static class Builder
    implements RemoveIndexCommandBuilder {
        private int indexId;

        private Builder() {
        }

        @Override
        public Builder indexId(int indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new RemoveIndexCommand(this.indexId);
        }
    }
}

