/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.util.Objects;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WhileStatement
extends Statement {
    public final Expression condition;
    public final Statement body;

    public WhileStatement(Expression condition, Statement body) {
        super(ExpressionType.While, Void.TYPE);
        this.condition = Objects.requireNonNull(condition, "condition");
        this.body = Objects.requireNonNull(body, "body");
    }

    @Override
    public Statement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression condition1 = this.condition.accept(shuttle);
        Statement body1 = this.body.accept(shuttle);
        return shuttle.visit(this, condition1, body1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("while (").append(this.condition).append(") ").append(Blocks.toBlock(this.body));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WhileStatement that = (WhileStatement)o;
        return this.body.equals(that.body) && this.condition.equals(that.condition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.condition, this.body});
    }
}

