/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling;

import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.cron.CronExpression;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.Supplier;

@Internal
final class NextFireTime
implements Supplier<Duration> {
    private Duration duration;
    private ZonedDateTime nextFireTime;
    private final CronExpression cron;
    private final ZoneId zoneId;

    NextFireTime(CronExpression cron) {
        this(cron, ZoneId.systemDefault());
    }

    NextFireTime(CronExpression cron, ZoneId zoneId) {
        this.cron = cron;
        this.zoneId = zoneId;
        this.nextFireTime = ZonedDateTime.now(zoneId);
    }

    @Override
    public Duration get() {
        ZonedDateTime now = ZonedDateTime.now(this.zoneId);
        this.computeNextFireTime(now.isAfter(this.nextFireTime) ? now : this.nextFireTime);
        return this.duration;
    }

    private void computeNextFireTime(ZonedDateTime currentFireTime) {
        this.nextFireTime = this.cron.nextTimeAfter(currentFireTime);
        this.duration = Duration.ofMillis(this.nextFireTime.toInstant().toEpochMilli() - ZonedDateTime.now(this.zoneId).toInstant().toEpochMilli());
    }
}

