/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.HashUtils;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.TemporalTypeUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class HashCalculator {
    private int hash = 0;

    public void append(@Nullable Object v, int scale, int precision) {
        this.combine(HashCalculator.hashValue(v, scale, precision));
    }

    public static int hashValue(@Nullable Object v, int scale, int precision) {
        if (v == null) {
            return HashCalculator.hashByte((byte)0);
        }
        if (v.getClass() == Boolean.class) {
            return HashCalculator.hashBoolean((Boolean)v);
        }
        if (v.getClass() == Byte.class) {
            return HashCalculator.hashByte((Byte)v);
        }
        if (v.getClass() == Short.class) {
            return HashCalculator.hashShort((Short)v);
        }
        if (v.getClass() == Integer.class) {
            return HashCalculator.hashInt((Integer)v);
        }
        if (v.getClass() == Long.class) {
            return HashCalculator.hashLong((Long)v);
        }
        if (v.getClass() == Float.class) {
            return HashCalculator.hashFloat(((Float)v).floatValue());
        }
        if (v.getClass() == Double.class) {
            return HashCalculator.hashDouble((Double)v);
        }
        if (v.getClass() == BigDecimal.class) {
            return HashCalculator.hashDecimal((BigDecimal)v, scale);
        }
        if (v.getClass() == UUID.class) {
            return HashCalculator.hashUuid((UUID)v);
        }
        if (v.getClass() == LocalDate.class) {
            return HashCalculator.hashDate((LocalDate)v);
        }
        if (v.getClass() == LocalTime.class) {
            return HashCalculator.hashTime((LocalTime)v, precision);
        }
        if (v.getClass() == LocalDateTime.class) {
            return HashCalculator.hashDateTime((LocalDateTime)v, precision);
        }
        if (v.getClass() == Instant.class) {
            return HashCalculator.hashTimestamp((Instant)v, precision);
        }
        if (v.getClass() == byte[].class) {
            return HashCalculator.hashBytes((byte[])v);
        }
        if (v.getClass() == String.class) {
            return HashCalculator.hashString((String)v);
        }
        throw new IgniteInternalException("Unsupported value type: [cls=" + String.valueOf(v.getClass()) + "]");
    }

    public void appendNull() {
        this.appendByte((byte)0);
    }

    public void appendBoolean(boolean v) {
        this.combine(HashCalculator.hashBoolean(v));
    }

    public static int hashBoolean(boolean v) {
        return HashUtils.hash32(ByteUtils.booleanToByte(v));
    }

    public void appendByte(byte v) {
        this.combine(HashCalculator.hashByte(v));
    }

    public static int hashByte(byte v) {
        return HashUtils.hash32(v);
    }

    public void appendShort(short v) {
        this.combine(HashCalculator.hashShort(v));
    }

    public static int hashShort(short v) {
        return HashUtils.hash32(v);
    }

    public void appendInt(int v) {
        this.combine(HashCalculator.hashInt(v));
    }

    public static int hashInt(int v) {
        return HashUtils.hash32(v);
    }

    public void appendLong(long v) {
        this.combine(HashCalculator.hashLong(v));
    }

    public static int hashLong(long v) {
        return HashUtils.hash32(v);
    }

    public void appendFloat(float v) {
        this.combine(HashCalculator.hashFloat(v));
    }

    public static int hashFloat(float v) {
        return HashUtils.hash32(Float.floatToRawIntBits(v));
    }

    public void appendDouble(double v) {
        this.combine(HashCalculator.hashDouble(v));
    }

    public static int hashDouble(double v) {
        return HashUtils.hash32(Double.doubleToRawLongBits(v));
    }

    public void appendDecimal(BigDecimal v, int columnScale) {
        this.combine(HashCalculator.hashDecimal(v, columnScale));
    }

    public static int hashDecimal(BigDecimal v, int columnScale) {
        return HashCalculator.hashBytes(v.setScale(columnScale, RoundingMode.HALF_UP).unscaledValue().toByteArray());
    }

    public void appendUuid(UUID v) {
        this.combine(HashCalculator.hashUuid(v));
    }

    public static int hashUuid(UUID v) {
        return HashUtils.hash32(v.getLeastSignificantBits(), HashUtils.hash32(v.getMostSignificantBits()));
    }

    public void appendString(String v) {
        this.combine(HashCalculator.hashString(v));
    }

    public static int hashString(String v) {
        return HashCalculator.hashBytes(v.getBytes(StandardCharsets.UTF_8));
    }

    public void appendBytes(byte[] v) {
        this.combine(HashCalculator.hashBytes(v));
    }

    public static int hashBytes(byte[] v) {
        return HashUtils.hash32(v);
    }

    public void appendDate(LocalDate v) {
        this.combine(HashCalculator.hashDate(v));
    }

    public static int hashDate(LocalDate v) {
        return HashUtils.hash32(v.getDayOfMonth(), HashUtils.hash32(v.getMonthValue(), HashUtils.hash32(v.getYear())));
    }

    public void appendTime(LocalTime v, int precision) {
        this.combine(HashCalculator.hashTime(v, precision));
    }

    public static int hashTime(LocalTime v, int precision) {
        int hourHash = HashUtils.hash32(v.getHour());
        int minuteHash = HashUtils.hash32(v.getMinute(), hourHash);
        int secondHash = HashUtils.hash32(v.getSecond(), minuteHash);
        return HashUtils.hash32(TemporalTypeUtils.normalizeNanos(v.getNano(), precision), secondHash);
    }

    public void appendDateTime(LocalDateTime v, int precision) {
        this.combine(HashCalculator.hashDateTime(v, precision));
    }

    public static int hashDateTime(LocalDateTime v, int precision) {
        return HashUtils.combine(HashCalculator.hashDate(v.toLocalDate()), HashCalculator.hashTime(v.toLocalTime(), precision));
    }

    public void appendTimestamp(Instant v, int precision) {
        this.combine(HashCalculator.hashTimestamp(v, precision));
    }

    public static int hashTimestamp(Instant v, int precision) {
        return HashUtils.hash32(TemporalTypeUtils.normalizeNanos(v.getNano(), precision), HashCalculator.hashLong(v.getEpochSecond()));
    }

    public void combine(int anotherHash) {
        this.hash = HashUtils.combine(this.hash, anotherHash);
    }

    public static int combinedHash(int[] hashes) {
        int hash = 0;
        for (int h : hashes) {
            hash = HashUtils.combine(hash, h);
        }
        return hash;
    }

    public int hash() {
        return this.hash;
    }

    public void reset() {
        this.hash = 0;
    }
}

