/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.StorageRebalanceException;
import org.apache.ignite.internal.storage.util.StorageOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class MvPartitionStorages<T extends MvPartitionStorage> {
    private final int tableId;
    private final AtomicReferenceArray<T> storageByPartitionId;
    private final ConcurrentMap<Integer, StorageOperation> operationByPartitionId = new ConcurrentHashMap<Integer, StorageOperation>();
    private final ConcurrentMap<Integer, CompletableFuture<Void>> rebalanceFutureByPartitionId = new ConcurrentHashMap<Integer, CompletableFuture<Void>>();

    public MvPartitionStorages(int tableId, int partitions) {
        this.tableId = tableId;
        this.storageByPartitionId = new AtomicReferenceArray(partitions);
    }

    @Nullable
    public T get(int partitionId) {
        this.checkPartitionId(partitionId);
        return (T)((MvPartitionStorage)this.storageByPartitionId.get(partitionId));
    }

    public CompletableFuture<MvPartitionStorage> create(int partitionId, IntFunction<T> createStorageFunction) {
        StorageOperation storageOperation = this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            if (operation instanceof StorageOperation.DestroyStorageOperation) {
                if (!((StorageOperation.DestroyStorageOperation)operation).setCreationOperation(new StorageOperation.CreateStorageOperation())) {
                    throw new StorageException("Creation of the storage after its destruction is already planned: [" + this.createStorageInfo(partitionId) + "]");
                }
                return operation;
            }
            if (this.get(partitionId) != null) {
                throw new StorageException("Storage already exists: [" + this.createStorageInfo(partitionId) + "]");
            }
            if (operation != null) {
                this.throwExceptionDependingOnOperation((StorageOperation)operation, partitionId);
            }
            return new StorageOperation.CreateStorageOperation();
        });
        CompletableFuture<Void> destroyStorageFuture = storageOperation instanceof StorageOperation.DestroyStorageOperation ? ((StorageOperation.DestroyStorageOperation)storageOperation).getDestroyFuture() : CompletableFutures.nullCompletedFuture();
        return ((CompletableFuture)destroyStorageFuture.thenApply(unused -> {
            MvPartitionStorage newStorage = (MvPartitionStorage)createStorageFunction.apply(partitionId);
            boolean set = this.storageByPartitionId.compareAndSet(partitionId, null, newStorage);
            assert (set) : this.createStorageInfo(partitionId);
            return newStorage;
        })).whenComplete((storage, throwable) -> this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            assert (operation instanceof StorageOperation.CreateStorageOperation) : this.createStorageInfo(partitionId) + ", op=" + String.valueOf(operation);
            return MvPartitionStorages.nextOperationIfAvailable(operation);
        }));
    }

    public CompletableFuture<Void> destroy(int partitionId, Function<T, CompletableFuture<Void>> destroyStorageFunction) {
        StorageOperation.DestroyStorageOperation destroyOp = (StorageOperation.DestroyStorageOperation)this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            this.checkStorageExists(partitionId);
            if (operation != null) {
                this.throwExceptionDependingOnOperation((StorageOperation)operation, partitionId);
            }
            return new StorageOperation.DestroyStorageOperation();
        });
        MvPartitionStorage storage = this.storageByPartitionId.getAndSet(partitionId, null);
        return ((CompletableFuture)CompletableFutures.nullCompletedFuture().thenCompose(unused -> (CompletionStage)destroyStorageFunction.apply(storage))).whenComplete((unused, throwable) -> {
            this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
                assert (operation instanceof StorageOperation.DestroyStorageOperation) : this.createStorageInfo(partitionId) + ", op=" + String.valueOf(operation);
                return MvPartitionStorages.nextOperationIfAvailable(operation);
            });
            if (throwable == null) {
                destroyOp.getDestroyFuture().complete(null);
            } else {
                destroyOp.getDestroyFuture().completeExceptionally((Throwable)throwable);
            }
        });
    }

    public CompletableFuture<Void> clear(int partitionId, Function<T, CompletableFuture<Void>> clearStorageFunction) {
        this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            this.checkStorageExists(partitionId);
            if (operation != null) {
                this.throwExceptionDependingOnOperation((StorageOperation)operation, partitionId);
            }
            return new StorageOperation.CleanupStorageOperation();
        });
        return ((CompletableFuture)CompletableFutures.nullCompletedFuture().thenCompose(unused -> (CompletionStage)clearStorageFunction.apply(this.get(partitionId)))).whenComplete((unused, throwable) -> this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            assert (operation instanceof StorageOperation.CleanupStorageOperation) : this.createStorageInfo(partitionId) + ", op=" + String.valueOf(operation);
            return MvPartitionStorages.nextOperationIfAvailable(operation);
        }));
    }

    public CompletableFuture<Void> startRebalance(int partitionId, Function<T, CompletableFuture<Void>> startRebalanceStorageFunction) {
        StorageOperation.StartRebalanceStorageOperation startRebalanceOperation = (StorageOperation.StartRebalanceStorageOperation)this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            this.checkStorageExistsForRebalance(partitionId);
            if (operation != null) {
                this.throwExceptionDependingOnOperationForRebalance((StorageOperation)operation, partitionId);
            }
            if (this.rebalanceFutureByPartitionId.containsKey(partitionId)) {
                throw new StorageRebalanceException(this.createStorageInProgressOfRebalanceErrorMessage(partitionId));
            }
            return new StorageOperation.StartRebalanceStorageOperation();
        });
        return ((CompletableFuture)CompletableFutures.nullCompletedFuture().thenCompose(unused -> {
            CompletableFuture startRebalanceFuture = (CompletableFuture)startRebalanceStorageFunction.apply(this.get(partitionId));
            CompletableFuture<Void> old = this.rebalanceFutureByPartitionId.put(partitionId, startRebalanceFuture);
            assert (old == null) : this.createStorageInfo(partitionId);
            return startRebalanceFuture;
        })).whenComplete((unused, throwable) -> {
            this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
                assert (operation instanceof StorageOperation.StartRebalanceStorageOperation) : this.createStorageInfo(partitionId) + ", op=" + String.valueOf(operation);
                return MvPartitionStorages.nextOperationIfAvailable(operation);
            });
            startRebalanceOperation.getStartRebalanceFuture().complete(null);
        });
    }

    public CompletableFuture<Void> abortRebalance(int partitionId, Function<T, CompletableFuture<Void>> abortRebalanceStorageFunction) {
        StorageOperation storageOperation = this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            this.checkStorageExistsForRebalance(partitionId);
            if (operation instanceof StorageOperation.StartRebalanceStorageOperation) {
                if (!((StorageOperation.StartRebalanceStorageOperation)operation).setAbortOperation(new StorageOperation.AbortRebalanceStorageOperation())) {
                    throw new StorageRebalanceException("Rebalance abort is already planned: [{}]", this.createStorageInfo(partitionId));
                }
                return operation;
            }
            if (operation != null) {
                this.throwExceptionDependingOnOperationForRebalance((StorageOperation)operation, partitionId);
            }
            return new StorageOperation.AbortRebalanceStorageOperation();
        });
        CompletableFuture<Void> startRebalanceFuture = storageOperation instanceof StorageOperation.StartRebalanceStorageOperation ? ((StorageOperation.StartRebalanceStorageOperation)storageOperation).getStartRebalanceFuture() : CompletableFutures.nullCompletedFuture();
        return ((CompletableFuture)startRebalanceFuture.thenCompose(unused -> {
            CompletableFuture rebalanceFuture = (CompletableFuture)this.rebalanceFutureByPartitionId.remove(partitionId);
            if (rebalanceFuture == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return ((CompletableFuture)rebalanceFuture.handle((unused1, throwable) -> (CompletableFuture)abortRebalanceStorageFunction.apply(this.get(partitionId)))).thenCompose(Function.identity());
        })).whenComplete((unused, throwable) -> this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            assert (operation instanceof StorageOperation.AbortRebalanceStorageOperation) : this.createStorageInfo(partitionId) + ", op=" + String.valueOf(operation);
            return MvPartitionStorages.nextOperationIfAvailable(operation);
        }));
    }

    public CompletableFuture<Void> finishRebalance(int partitionId, Function<T, CompletableFuture<Void>> finishRebalanceStorageFunction) {
        this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            this.checkStorageExistsForRebalance(partitionId);
            if (operation != null) {
                this.throwExceptionDependingOnOperationForRebalance((StorageOperation)operation, partitionId);
            }
            if (!this.rebalanceFutureByPartitionId.containsKey(partitionId)) {
                throw new StorageRebalanceException("Storage rebalancing did not start: [" + this.createStorageInfo(partitionId) + "]");
            }
            return new StorageOperation.FinishRebalanceStorageOperation();
        });
        return ((CompletableFuture)CompletableFutures.nullCompletedFuture().thenCompose(unused -> {
            CompletableFuture rebalanceFuture = (CompletableFuture)this.rebalanceFutureByPartitionId.remove(partitionId);
            assert (rebalanceFuture != null) : this.createStorageInfo(partitionId);
            return rebalanceFuture.thenCompose(unused1 -> (CompletionStage)finishRebalanceStorageFunction.apply(this.get(partitionId)));
        })).whenComplete((unused, throwable) -> this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
            assert (operation instanceof StorageOperation.FinishRebalanceStorageOperation) : this.createStorageInfo(partitionId) + ", op=" + String.valueOf(operation);
            return MvPartitionStorages.nextOperationIfAvailable(operation);
        }));
    }

    public String createStorageInfo(int partitionId) {
        return IgniteStringFormatter.format((String)"tableId={}, partitionId={}", (Object[])new Object[]{this.tableId, partitionId});
    }

    private void checkPartitionId(int partitionId) {
        int partitions = this.storageByPartitionId.length();
        if (partitionId < 0 || partitionId >= partitions) {
            throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Unable to access partition with id outside of configured range: [tableId={}, partitionId={}, partitions={}]", (Object[])new Object[]{this.tableId, partitionId, partitions}));
        }
    }

    private void checkStorageExists(int partitionId) {
        if (this.get(partitionId) == null) {
            throw new StorageException(this.createStorageDoesNotExistErrorMessage(partitionId));
        }
    }

    private void checkStorageExistsForRebalance(int partitionId) {
        if (this.get(partitionId) == null) {
            throw new StorageRebalanceException(this.createStorageDoesNotExistErrorMessage(partitionId));
        }
    }

    private void throwExceptionDependingOnOperation(StorageOperation operation, int partitionId) {
        throw new StorageException(operation.inProcessErrorMessage(this.createStorageInfo(partitionId)));
    }

    private void throwExceptionDependingOnOperationForRebalance(StorageOperation operation, int partitionId) {
        throw new StorageRebalanceException(operation.inProcessErrorMessage(this.createStorageInfo(partitionId)));
    }

    private String createStorageDoesNotExistErrorMessage(int partitionId) {
        return "Storage does not exist: [" + this.createStorageInfo(partitionId) + "]";
    }

    private String createStorageInProgressOfRebalanceErrorMessage(int partitionId) {
        return "Storage in the process of rebalance: [" + this.createStorageInfo(partitionId) + "]";
    }

    @Nullable
    private static StorageOperation nextOperationIfAvailable(StorageOperation operation) {
        operation.operationFuture().complete(null);
        if (operation.isFinalOperation()) {
            return operation;
        }
        if (operation instanceof StorageOperation.DestroyStorageOperation) {
            return ((StorageOperation.DestroyStorageOperation)operation).getCreateStorageOperation();
        }
        if (operation instanceof StorageOperation.StartRebalanceStorageOperation) {
            return ((StorageOperation.StartRebalanceStorageOperation)operation).getAbortRebalanceOperation();
        }
        return null;
    }

    public List<T> getAll() {
        ArrayList<MvPartitionStorage> list = new ArrayList<MvPartitionStorage>(this.storageByPartitionId.length());
        for (int i = 0; i < this.storageByPartitionId.length(); ++i) {
            MvPartitionStorage storage = (MvPartitionStorage)this.storageByPartitionId.get(i);
            if (storage == null) continue;
            list.add(storage);
        }
        return list;
    }

    public CompletableFuture<List<T>> getAllForCloseOrDestroy() {
        ArrayList<CompletableFuture<Void>> operationFutures = new ArrayList<CompletableFuture<Void>>();
        for (int partitionId = 0; partitionId < this.storageByPartitionId.length(); ++partitionId) {
            StorageOperation storageOperation = this.operationByPartitionId.compute(partitionId, (partId, operation) -> {
                if (operation == null) {
                    operation = new StorageOperation.CloseStorageOperation();
                }
                operation.markFinalOperation();
                return operation;
            });
            if (storageOperation instanceof StorageOperation.CloseStorageOperation) continue;
            operationFutures.add(storageOperation.operationFuture());
        }
        return CompletableFuture.allOf((CompletableFuture[])operationFutures.toArray(CompletableFuture[]::new)).thenApply(unused -> IntStream.range(0, this.storageByPartitionId.length()).mapToObj(partitionId -> this.storageByPartitionId.getAndSet(partitionId, null)).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

