/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.cluster;

import io.micronaut.http.annotation.Controller;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.cluster.TopologyApi;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeMetadata;

@Controller(value="/management/v1/cluster/topology")
public class TopologyController
implements TopologyApi,
ResourceHolder {
    private TopologyService topologyService;
    private ClusterManagementGroupManager cmgManager;

    public TopologyController(TopologyService topologyService, ClusterManagementGroupManager cmgManager) {
        this.topologyService = topologyService;
        this.cmgManager = cmgManager;
    }

    public Collection<org.apache.ignite.internal.rest.api.cluster.ClusterNode> physicalTopology() {
        return TopologyController.toClusterNodeDtos(this.topologyService.allMembers());
    }

    public CompletableFuture<Collection<org.apache.ignite.internal.rest.api.cluster.ClusterNode>> logicalTopology() {
        return ((CompletableFuture)((CompletableFuture)this.cmgManager.clusterState().thenCompose(state -> this.cmgManager.logicalTopology())).thenApply(LogicalTopologySnapshot::nodes)).thenApply(TopologyController::toClusterNodeDtosFromLogicalNodes);
    }

    private static List<org.apache.ignite.internal.rest.api.cluster.ClusterNode> toClusterNodeDtos(Collection<ClusterNode> nodes) {
        return nodes.stream().map(TopologyController::toClusterNodeDto).collect(Collectors.toList());
    }

    private static List<org.apache.ignite.internal.rest.api.cluster.ClusterNode> toClusterNodeDtosFromLogicalNodes(Collection<LogicalNode> nodes) {
        return nodes.stream().map(TopologyController::toClusterNodeDto).collect(Collectors.toList());
    }

    private static org.apache.ignite.internal.rest.api.cluster.ClusterNode toClusterNodeDto(ClusterNode node) {
        NetworkAddress addr = node.address();
        org.apache.ignite.internal.rest.api.cluster.NetworkAddress addrDto = new org.apache.ignite.internal.rest.api.cluster.NetworkAddress(addr.host(), addr.port());
        return new org.apache.ignite.internal.rest.api.cluster.ClusterNode(node.id(), node.name(), addrDto, TopologyController.toNodeMetadataDto(node.nodeMetadata()));
    }

    private static org.apache.ignite.internal.rest.api.cluster.NodeMetadata toNodeMetadataDto(NodeMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        return new org.apache.ignite.internal.rest.api.cluster.NodeMetadata(metadata.restHost(), metadata.httpPort(), metadata.httpsPort());
    }

    public void cleanResources() {
        this.topologyService = null;
        this.cmgManager = null;
    }
}

