/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.ActionResponse;
import org.apache.ignite.raft.jraft.rpc.ActionResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.ActionResponseSerializer;

public class ActionResponseImpl
implements ActionResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 4002;
    @IgniteToStringInclude
    private Object result;
    private byte[] resultByteArray;

    private ActionResponseImpl(Object result, byte[] resultByteArray) {
        this.result = result;
        this.resultByteArray = resultByteArray;
    }

    byte[] resultByteArray() {
        return this.resultByteArray;
    }

    @Override
    public Object result() {
        return this.result;
    }

    public MessageSerializer serializer() {
        return ActionResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ActionResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 4002;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ActionResponseImpl otherMessage = (ActionResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result);
        return result;
    }

    public ActionResponseImpl clone() {
        try {
            return (ActionResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ActionResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject resultByteArraymo = marshaller.marshal(this.result);
        usedDescriptors.addAll((IntCollection)resultByteArraymo.usedDescriptorIds());
        this.resultByteArray = resultByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.result = marshaller.unmarshal(this.resultByteArray, descriptorsObj);
        this.resultByteArray = null;
    }

    private static class Builder
    implements ActionResponseBuilder {
        private Object result;
        private byte[] resultByteArray;

        private Builder() {
        }

        @Override
        public ActionResponseBuilder result(Object result) {
            this.result = result;
            return this;
        }

        @Override
        public ActionResponseBuilder resultByteArray(byte[] resultByteArray) {
            this.resultByteArray = resultByteArray;
            return this;
        }

        @Override
        public Object result() {
            return this.result;
        }

        @Override
        public byte[] resultByteArray() {
            return this.resultByteArray;
        }

        @Override
        public ActionResponse build() {
            return new ActionResponseImpl(this.result, this.resultByteArray);
        }
    }
}

