/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.partition;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.partition.HashPartition;
import org.apache.ignite.lang.UnsupportedPartitionTypeException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.Partition;
import org.apache.ignite.table.partition.PartitionManager;

public class HashPartitionManagerImpl
implements PartitionManager {
    private final InternalTable table;
    private final SchemaRegistry schemaReg;
    private final MarshallersProvider marshallers;

    public HashPartitionManagerImpl(InternalTable table, SchemaRegistry schemaReg, MarshallersProvider marshallers) {
        this.table = table;
        this.schemaReg = schemaReg;
        this.marshallers = marshallers;
    }

    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        if (!(partition instanceof HashPartition)) {
            throw new UnsupportedPartitionTypeException("Table " + this.table.name() + " doesn't support any other type of partition except hash partition.");
        }
        HashPartition hashPartition = (HashPartition)partition;
        return this.table.partitionLocation(new TablePartitionId(this.table.tableId(), hashPartition.partitionId()));
    }

    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        int partitions = this.table.partitions();
        CompletableFuture[] futures = new CompletableFuture[partitions];
        for (int i = 0; i < partitions; ++i) {
            futures[i] = this.table.partitionLocation(new TablePartitionId(this.table.tableId(), i));
        }
        return CompletableFuture.allOf(futures).thenApply(unused -> {
            HashMap<HashPartition, ClusterNode> result = new HashMap<HashPartition, ClusterNode>(partitions);
            for (int i = 0; i < partitions; ++i) {
                result.put(new HashPartition(i), (ClusterNode)futures[i].join());
            }
            return result;
        });
    }

    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mapper);
        KvMarshallerImpl marshaller = new KvMarshallerImpl(this.schemaReg.lastKnownSchema(), this.marshallers, mapper, mapper);
        Row keyRow = marshaller.marshal(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId((BinaryRowEx)keyRow)));
    }

    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        Objects.requireNonNull(key);
        Row keyRow = new TupleMarshallerImpl(this.schemaReg.lastKnownSchema()).marshalKey(key);
        return CompletableFuture.completedFuture(new HashPartition(this.table.partitionId((BinaryRowEx)keyRow)));
    }
}

