/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMdColumnOrigins;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.ignite.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceAggregateBase;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteMdColumnOrigins
implements MetadataHandler<BuiltInMetadata.ColumnOrigin> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new IgniteMdColumnOrigins(), BuiltInMetadata.ColumnOrigin.Handler.class);

    private IgniteMdColumnOrigins() {
    }

    public MetadataDef<BuiltInMetadata.ColumnOrigin> getDef() {
        return BuiltInMetadata.ColumnOrigin.DEF;
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(RelSubset rel, RelMetadataQuery mq, int outputColumn) {
        return mq.getColumnOrigins(rel.stripped(), outputColumn);
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(IgniteReduceAggregateBase rel, RelMetadataQuery mq, int outputColumn) {
        if (outputColumn < rel.getGroupSet().cardinality()) {
            return mq.getColumnOrigins(rel.getInput(), ((Integer)rel.getGroupSet().asList().get(outputColumn)).intValue());
        }
        return null;
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(ProjectableFilterableTableScan scan, RelMetadataQuery mq, int outputColumn) {
        Mapping trimming;
        ImmutableBitSet requiredColumns;
        RelOptTable table = scan.getTable();
        List<RexNode> projects = scan.projects();
        if (projects != null) {
            RexNode node = projects.get(outputColumn);
            if (node instanceof RexInputRef) {
                RexInputRef inputRef = (RexInputRef)node;
                outputColumn = inputRef.getIndex();
            } else {
                return null;
            }
        }
        if ((requiredColumns = scan.requiredColumns()) != null && (outputColumn = (trimming = Commons.trimmingMapping(table.getRowType().getFieldCount(), requiredColumns)).getSourceOpt(outputColumn)) == -1) {
            return null;
        }
        return Set.of(new RelColumnOrigin(table, outputColumn, false));
    }

    @Nullable
    public Set<RelColumnOrigin> getColumnOrigins(RelNode rel, RelMetadataQuery mq, int outputColumn) {
        Method method = ReflectUtil.lookupVisitMethod((Class)RelMdColumnOrigins.SOURCE.getClass(), (Class)rel.getClass(), (String)"getColumnOrigins", List.of(RelMetadataQuery.class, Integer.TYPE));
        if (method == null) {
            return null;
        }
        try {
            return (Set)method.invoke((Object)RelMdColumnOrigins.SOURCE, rel, mq, outputColumn);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ExceptionUtils.sneakyThrow((Throwable)e);
            throw new AssertionError((Object)"Should not get here");
        }
    }
}

