/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.sql.engine.exec.DestinationFactory;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.PartitionProvider;
import org.apache.ignite.internal.sql.engine.exec.ResolvedDependencies;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlComparator;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.exec.exp.func.TableFunction;
import org.apache.ignite.internal.sql.engine.exec.exp.func.TableFunctionRegistry;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractSetOpNode;
import org.apache.ignite.internal.sql.engine.exec.rel.CorrelatedNestedLoopJoinNode;
import org.apache.ignite.internal.sql.engine.exec.rel.DataSourceScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.FilterNode;
import org.apache.ignite.internal.sql.engine.exec.rel.HashAggregateNode;
import org.apache.ignite.internal.sql.engine.exec.rel.HashJoinNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Inbox;
import org.apache.ignite.internal.sql.engine.exec.rel.IndexScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.IndexSpoolNode;
import org.apache.ignite.internal.sql.engine.exec.rel.IntersectNode;
import org.apache.ignite.internal.sql.engine.exec.rel.LimitNode;
import org.apache.ignite.internal.sql.engine.exec.rel.MergeJoinNode;
import org.apache.ignite.internal.sql.engine.exec.rel.MinusNode;
import org.apache.ignite.internal.sql.engine.exec.rel.ModifyNode;
import org.apache.ignite.internal.sql.engine.exec.rel.NestedLoopJoinNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite.internal.sql.engine.exec.rel.ProjectNode;
import org.apache.ignite.internal.sql.engine.exec.rel.ScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.SortAggregateNode;
import org.apache.ignite.internal.sql.engine.exec.rel.SortNode;
import org.apache.ignite.internal.sql.engine.exec.rel.TableScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.TableSpoolNode;
import org.apache.ignite.internal.sql.engine.exec.rel.UnionAllNode;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteMergeJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteUnionAll;
import org.apache.ignite.internal.sql.engine.rel.IgniteValues;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteIntersect;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteMapSetOp;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteReduceIntersect;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.rule.LogicalScanConverterRule;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.Destination;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class LogicalRelImplementor<RowT>
implements IgniteRelVisitor<Node<RowT>> {
    public static final String CNLJ_NOT_SUPPORTED_JOIN_ASSERTION_MSG = "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
    private final ExecutionContext<RowT> ctx;
    private final DestinationFactory<RowT> destinationFactory;
    private final ExchangeService exchangeSvc;
    private final MailboxRegistry mailboxRegistry;
    private final ExpressionFactory<RowT> expressionFactory;
    private final ResolvedDependencies resolvedDependencies;
    private final TableFunctionRegistry tableFunctionRegistry;

    public LogicalRelImplementor(ExecutionContext<RowT> ctx, MailboxRegistry mailboxRegistry, ExchangeService exchangeSvc, ResolvedDependencies resolvedDependencies, TableFunctionRegistry tableFunctionRegistry) {
        this.mailboxRegistry = mailboxRegistry;
        this.exchangeSvc = exchangeSvc;
        this.ctx = ctx;
        this.resolvedDependencies = resolvedDependencies;
        this.tableFunctionRegistry = tableFunctionRegistry;
        this.expressionFactory = ctx.expressionFactory();
        this.destinationFactory = new DestinationFactory<RowT>(ctx.rowHandler(), resolvedDependencies);
    }

    @Override
    public Node<RowT> visit(IgniteSender rel) {
        IgniteDistribution distribution = rel.distribution();
        ColocationGroup targetGroup = this.ctx.target();
        assert (targetGroup != null);
        Destination<RowT> dest = this.destinationFactory.createDestination(distribution, targetGroup);
        Outbox<RowT> outbox = new Outbox<RowT>(this.ctx, this.exchangeSvc, this.mailboxRegistry, rel.exchangeId(), rel.targetFragmentId(), dest);
        Node<RowT> input = this.visit(rel.getInput());
        outbox.register(input);
        this.mailboxRegistry.register(outbox);
        return outbox;
    }

    @Override
    public Node<RowT> visit(IgniteFilter rel) {
        Predicate<Object> pred = row -> this.expressionFactory.predicate(rel.getCondition(), rel.getRowType()).test(this.ctx, row);
        FilterNode<Object> node = new FilterNode<Object>(this.ctx, pred);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTrimExchange rel) {
        assert (TraitUtils.distribution((RelNode)rel).getType() == RelDistribution.Type.HASH_DISTRIBUTED);
        ColocationGroup targetGroup = this.ctx.group(rel.sourceId());
        assert (targetGroup != null);
        Destination dest = this.destinationFactory.createDestination(rel.distribution(), targetGroup);
        String localNodeName = this.ctx.localNode().name();
        FilterNode<Object> node = new FilterNode<Object>(this.ctx, r -> Objects.equals(localNodeName, CollectionUtils.first(dest.targets(r))));
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteProject rel) {
        Function<Object, Object> prj = row -> this.expressionFactory.project(rel.getProjects(), rel.getInput().getRowType()).project(this.ctx, row);
        ProjectNode<Object> node = new ProjectNode<Object>(this.ctx, prj);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteNestedLoopJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
        BiPredicate<Object, Object> cond = (left, right) -> this.expressionFactory.joinPredicate(rel.getCondition(), rowType).test(this.ctx, left, right);
        NestedLoopJoinNode<Object> node = NestedLoopJoinNode.create(this.ctx, outType, leftType, rightType, joinType, cond);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteHashJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        RexNode nonEquiConditionExpression = RexUtil.composeConjunction((RexBuilder)Commons.rexBuilder(), (Iterable)rel.analyzeCondition().nonEquiConditions, (boolean)true);
        BiPredicate<Object, Object> nonEquiCondition = null;
        if (nonEquiConditionExpression != null) {
            RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
            nonEquiCondition = (left, right) -> this.expressionFactory.joinPredicate(rel.getCondition(), rowType).test(this.ctx, left, right);
        }
        HashJoinNode<RowT> node = HashJoinNode.create(this.ctx, outType, leftType, rightType, joinType, rel.analyzeCondition(), nonEquiCondition);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteCorrelatedNestedLoopJoin rel) {
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        RowSchema rightRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rightType));
        RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
        BiPredicate<Object, Object> cond = (left, right) -> this.expressionFactory.joinPredicate(rel.getCondition(), rowType).test(this.ctx, left, right);
        assert (rel.getJoinType() == JoinRelType.INNER || rel.getJoinType() == JoinRelType.LEFT) : "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
        RowHandler.RowFactory<RowT> rightRowFactory = this.ctx.rowHandler().factory(rightRowSchema);
        RowHandler.RowFactory<RowT> outputRowFactory = this.ctx.rowHandler().factory(TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType)));
        CorrelatedNestedLoopJoinNode<Object> node = new CorrelatedNestedLoopJoinNode<Object>(this.ctx, cond, rel.getVariablesSet(), rel.getJoinType(), rightRowFactory, outputRowFactory);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMergeJoin rel) {
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        int pairsCnt = rel.analyzeCondition().pairs().size();
        final ImmutableBitSet leftKeys = rel.analyzeCondition().leftSet();
        List conjunctions = RelOptUtil.conjunctions((RexNode)rel.getCondition());
        final ImmutableBitSet.Builder nullCompAsEqualBuilder = ImmutableBitSet.builder();
        RexShuttle shuttle = new RexShuttle(){

            public RexNode visitInputRef(RexInputRef ref) {
                int idx = ref.getIndex();
                if (leftKeys.get(idx)) {
                    nullCompAsEqualBuilder.set(idx);
                }
                return ref;
            }
        };
        for (RexNode expr : conjunctions) {
            if (expr.getKind() != SqlKind.IS_NOT_DISTINCT_FROM) continue;
            shuttle.apply(expr);
        }
        ImmutableBitSet nullCompAsEqual = nullCompAsEqualBuilder.build();
        Comparator comp = (r1, r2) -> this.expressionFactory.comparator(rel.leftCollation().getFieldCollations().subList(0, pairsCnt), rel.rightCollation().getFieldCollations().subList(0, pairsCnt), nullCompAsEqual).compare(this.ctx, r1, r2);
        MergeJoinNode<RowT> node = MergeJoinNode.create(this.ctx, leftType, rightType, joinType, comp);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteIndexScan rel) {
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        ImmutableBitSet requiredColumns = rel.requiredColumns();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        ScannableTable scannableTable = this.resolvedDependencies.scannableTable(tbl.id());
        IgniteIndex idx = tbl.indexes().get(rel.indexName());
        List<SearchBounds> searchBounds = rel.searchBounds();
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        Predicate<Object> filters = condition == null ? null : row -> this.expressionFactory.predicate(condition, rowType).test(this.ctx, row);
        Function<Object, Object> prj = projects == null ? null : row -> this.expressionFactory.project(projects, rowType).project(this.ctx, row);
        RangeIterable<RowT> ranges = null;
        if (searchBounds != null) {
            SqlComparator<RowT> searchRowComparator = idx.type() == IgniteIndex.Type.SORTED ? this.expressionFactory.comparator(IgniteIndex.createSearchRowCollation(idx.collation())) : null;
            ranges = this.expressionFactory.ranges(searchBounds, idx.rowType(typeFactory, tbl.descriptor()), searchRowComparator).get(this.ctx);
        }
        RelCollation outputCollation = rel.collation();
        if (projects != null || requiredColumns != null) {
            outputCollation = (RelCollation)outputCollation.apply(LogicalScanConverterRule.createMapping(projects, requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount()));
        }
        ColocationGroup group = this.ctx.group(rel.sourceId());
        assert (group != null);
        Comparator comp = null;
        if (idx.type() == IgniteIndex.Type.SORTED && outputCollation != null && !CollectionUtils.nullOrEmpty((Collection)outputCollation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(outputCollation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (!group.nodeNames().contains(this.ctx.localNode().name())) {
            return new ScanNode<RowT>(this.ctx, Collections.emptyList());
        }
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        PartitionProvider<RowT> partitionProvider = this.ctx.getPartitionProvider(rel.sourceId(), group, tbl);
        return new IndexScanNode<Object>(this.ctx, rowFactory, idx, scannableTable, tbl.descriptor(), partitionProvider, comp, ranges, filters, prj, requiredColumns == null ? null : requiredColumns.toBitSet());
    }

    @Override
    public Node<RowT> visit(IgniteTableScan rel) {
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        ImmutableBitSet requiredColumns = rel.requiredColumns();
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
        ScannableTable scannableTable = this.resolvedDependencies.scannableTable(tbl.id());
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        Predicate<Object> filters = condition == null ? null : row -> this.expressionFactory.predicate(condition, rowType).test(this.ctx, row);
        Function<Object, Object> prj = projects == null ? null : row -> this.expressionFactory.project(projects, rowType).project(this.ctx, row);
        long sourceId = rel.sourceId();
        ColocationGroup group = this.ctx.group(sourceId);
        assert (group != null);
        if (!group.nodeNames().contains(this.ctx.localNode().name())) {
            return new ScanNode<RowT>(this.ctx, Collections.emptyList());
        }
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        PartitionProvider<RowT> partitionProvider = this.ctx.getPartitionProvider(rel.sourceId(), group, tbl);
        return new TableScanNode<Object>(this.ctx, rowFactory, scannableTable, partitionProvider, filters, prj, requiredColumns == null ? null : requiredColumns.toBitSet());
    }

    @Override
    public Node<RowT> visit(IgniteSystemViewScan rel) {
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        ImmutableBitSet requiredColumns = rel.requiredColumns();
        IgniteDataSource igniteDataSource = (IgniteDataSource)rel.getTable().unwrapOrThrow(IgniteDataSource.class);
        BinaryTupleSchema schema = LogicalRelImplementor.fromTableDescriptor(igniteDataSource.descriptor());
        ScannableDataSource dataSource = this.resolvedDependencies.dataSource(igniteDataSource.id());
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        RelDataType rowType = igniteDataSource.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        Predicate<Object> filters = condition == null ? null : row -> this.expressionFactory.predicate(condition, rowType).test(this.ctx, row);
        Function<Object, Object> prj = projects == null ? null : row -> this.expressionFactory.project(projects, rowType).project(this.ctx, row);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        return new DataSourceScanNode<Object>(this.ctx, rowFactory, schema, dataSource, filters, prj, requiredColumns == null ? null : requiredColumns.toBitSet());
    }

    @Override
    public Node<RowT> visit(IgniteValues rel) {
        List<List<RexLiteral>> vals = Commons.cast(rel.getTuples());
        RelDataType rowType = rel.getRowType();
        return new ScanNode<RowT>(this.ctx, (Iterable)this.expressionFactory.values(vals, rowType).get(this.ctx));
    }

    @Override
    public Node<RowT> visit(IgniteUnionAll rel) {
        UnionAllNode node = new UnionAllNode(this.ctx);
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        node.register(inputs);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteLimit rel) {
        Supplier<Integer> offset = rel.offset() == null ? null : () -> (Integer)this.expressionFactory.scalar(rel.offset()).get(this.ctx);
        Supplier<Integer> fetch = rel.fetch() == null ? null : () -> (Integer)this.expressionFactory.scalar(rel.fetch()).get(this.ctx);
        LimitNode<RowT> node = new LimitNode<RowT>(this.ctx, offset, fetch);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSort rel) {
        RelCollation collation = rel.getCollation();
        Supplier<Integer> offset = rel.offset == null ? null : () -> (Integer)this.expressionFactory.scalar(rel.offset).get(this.ctx);
        Supplier<Integer> fetch = rel.fetch == null ? null : () -> (Integer)this.expressionFactory.scalar(rel.fetch).get(this.ctx);
        SortNode<RowT> node = new SortNode<RowT>(this.ctx, (r1, r2) -> this.expressionFactory.comparator(collation).compare(this.ctx, r1, r2), offset, fetch);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTableSpool rel) {
        TableSpoolNode<RowT> node = new TableSpoolNode<RowT>(this.ctx, rel.readType == Spool.Type.LAZY);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSortedIndexSpool rel) {
        RelCollation collation = rel.collation();
        assert (rel.searchBounds() != null) : rel;
        Predicate<Object> filter = row -> this.expressionFactory.predicate(rel.condition(), rel.getRowType()).test(this.ctx, row);
        SqlComparator<RowT> comparator = this.expressionFactory.comparator(collation);
        RangeIterable<RowT> ranges = this.expressionFactory.ranges(rel.searchBounds(), rel.getRowType(), comparator).get(this.ctx);
        IndexSpoolNode<Object> node = IndexSpoolNode.createTreeSpool(this.ctx, rel.getRowType(), collation, (r1, r2) -> comparator.compare(this.ctx, r1, r2), filter, ranges);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteHashIndexSpool rel) {
        Supplier<Object> searchRow = () -> this.expressionFactory.rowSource(rel.searchRow()).get(this.ctx);
        Predicate<Object> filter = row -> this.expressionFactory.predicate(rel.condition(), rel.getRowType()).test(this.ctx, row);
        IndexSpoolNode<Object> node = IndexSpoolNode.createHashSpool(this.ctx, ImmutableBitSet.of((Iterable)rel.keys()), filter, searchRow, rel.allowNulls());
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSetOp rel) {
        AbstractSetOpNode node;
        RelDataType rowType = rel.getRowType();
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        int columnNum = rel instanceof IgniteMapSetOp ? rel.getInput(0).getRowType().getFieldCount() : rowType.getFieldCount();
        if (rel instanceof Minus) {
            node = new MinusNode(this.ctx, columnNum, rel.aggregateType(), rel.all(), rowFactory);
        } else if (rel instanceof IgniteIntersect) {
            int inputsNum;
            if (rel instanceof IgniteReduceIntersect) {
                int inputCols = rel.getInput(0).getRowType().getFieldCount();
                int outputCols = rel.getRowType().getFieldCount();
                inputsNum = inputCols - outputCols;
            } else {
                inputsNum = rel.getInputs().size();
            }
            node = new IntersectNode<RowT>(this.ctx, columnNum, rel.aggregateType(), rel.all(), rowFactory, inputsNum);
        } else {
            throw new AssertionError((Object)("Unexpected set node: " + String.valueOf(rel)));
        }
        node.register(inputs);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTableFunctionScan rel) {
        TableFunction<RowT> tableFunction = this.tableFunctionRegistry.getTableFunction(this.ctx, (RexCall)rel.getCall());
        return new ScanNode<RowT>(this.ctx, tableFunction);
    }

    @Override
    public Node<RowT> visit(IgniteTableModify rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
        UpdatableTable updatableTable = this.resolvedDependencies.updatableTable(table.id());
        RelDataType rowType = rel.getInput().getRowType();
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        ModifyNode<RowT> node = new ModifyNode<RowT>(this.ctx, updatableTable, rel.sourceId(), rel.getOperation(), rel.getUpdateColumnList(), rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReceiver rel) {
        RelDataType rowType = rel.getRowType();
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty((Collection)collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        Inbox<RowT> inbox = new Inbox<RowT>(this.ctx, this.exchangeSvc, this.mailboxRegistry, this.ctx.remotes(rel.exchangeId()), comp, rowFactory, rel.exchangeId(), rel.sourceFragmentId());
        this.mailboxRegistry.register(inbox);
        return inbox;
    }

    @Override
    public Node<RowT> visit(IgniteColocatedHashAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, type, (List<ImmutableBitSet>)rel.getGroupSets(), accumulators, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMapHashAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, type, (List<ImmutableBitSet>)rel.getGroupSets(), accumulators, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReduceHashAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        List<Object> accumulators = rel.getAggregateCalls().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), rel.getInput().getRowType()).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, type, rel.getGroupSets(), accumulators, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteColocatedSortAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty((Collection)collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (rel.getGroupSet().isEmpty() && comp == null) {
            comp = (k1, k2) -> 0;
        }
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, type, rel.getGroupSet(), accumulators, rowFactory, comp);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMapSortAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        List<Object> accumulators = rel.getAggCallList().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty((Collection)collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (rel.getGroupSet().isEmpty() && comp == null) {
            comp = (k1, k2) -> 0;
        }
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, type, rel.getGroupSet(), accumulators, rowFactory, comp);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReduceSortAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        List<Object> accumulators = rel.getAggregateCalls().isEmpty() ? List.of() : this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), rel.getInput().getRowType()).get(this.ctx);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rowType));
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(rowSchema);
        RelCollation collation = rel.collation();
        Comparator comp = null;
        if (collation != null && !CollectionUtils.nullOrEmpty((Collection)collation.getFieldCollations())) {
            SqlComparator<RowT> searchRowComparator = this.expressionFactory.comparator(collation);
            comp = (r1, r2) -> searchRowComparator.compare(this.ctx, r1, r2);
        }
        if (rel.getGroupSet().isEmpty() && comp == null) {
            comp = (k1, k2) -> 0;
        }
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, type, rel.getGroupSet(), accumulators, rowFactory, comp);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteRel rel) {
        return (Node)rel.accept(this);
    }

    @Override
    public Node<RowT> visit(IgniteExchange rel) {
        throw new AssertionError(rel.getClass());
    }

    @Override
    public Node<RowT> visit(IgniteKeyValueGet rel) {
        throw new AssertionError(rel.getClass());
    }

    @Override
    public Node<RowT> visit(IgniteKeyValueModify rel) {
        throw new AssertionError(rel.getClass());
    }

    @Override
    public Node<RowT> visit(IgniteSelectCount rel) {
        throw new AssertionError(rel.getClass());
    }

    private Node<RowT> visit(RelNode rel) {
        return this.visit((IgniteRel)rel);
    }

    public <T extends Node<RowT>> T go(IgniteRel rel) {
        return (T)this.visit(rel);
    }

    private static BinaryTupleSchema fromTableDescriptor(TableDescriptor descriptor) {
        BinaryTupleSchema.Element[] elements = new BinaryTupleSchema.Element[descriptor.columnsCount()];
        int idx = 0;
        for (ColumnDescriptor column : descriptor) {
            elements[idx++] = new BinaryTupleSchema.Element(column.physicalType(), column.nullable());
        }
        return BinaryTupleSchema.create((BinaryTupleSchema.Element[])elements);
    }
}

