/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.AlterZoneEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.Node;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.rebalance.DistributionZoneRebalanceEngineV2;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.distributionzones.utils.CatalogAlterZoneEventListener;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.TestOnly;

public class DistributionZoneRebalanceEngine {
    private static final IgniteLogger LOG = Loggers.forClass(DistributionZoneRebalanceEngine.class);
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock;
    private final MetaStorageManager metaStorageManager;
    private final DistributionZoneManager distributionZoneManager;
    private final WatchListener dataNodesListener;
    private final CatalogService catalogService;
    private final DistributionZoneRebalanceEngineV2 distributionZoneRebalanceEngineV2;
    public static final String FEATURE_FLAG_NAME = "IGNITE_ZONE_BASED_REPLICATION";
    public static final boolean ENABLED = IgniteSystemProperties.getBoolean((String)"IGNITE_ZONE_BASED_REPLICATION", (boolean)false);
    @TestOnly
    public static final String SKIP_REBALANCE_TRIGGERS_RECOVERY = "IGNITE_SKIP_REBALANCE_TRIGGERS_RECOVERY";

    public DistributionZoneRebalanceEngine(IgniteSpinBusyLock busyLock, MetaStorageManager metaStorageManager, DistributionZoneManager distributionZoneManager, CatalogManager catalogService) {
        this.busyLock = busyLock;
        this.metaStorageManager = metaStorageManager;
        this.distributionZoneManager = distributionZoneManager;
        this.catalogService = catalogService;
        this.dataNodesListener = this.createDistributionZonesDataNodesListener();
        this.distributionZoneRebalanceEngineV2 = new DistributionZoneRebalanceEngineV2(busyLock, metaStorageManager, distributionZoneManager, catalogService);
    }

    public CompletableFuture<Void> startAsync(int catalogVersion) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.catalogService.listen((Event)CatalogEvent.ZONE_ALTER, (EventListener)new CatalogAlterZoneEventListener(this.catalogService){

                @Override
                protected CompletableFuture<Void> onReplicasUpdate(AlterZoneEventParameters parameters, int oldReplicas) {
                    return DistributionZoneRebalanceEngine.this.onUpdateReplicas(parameters);
                }
            });
            this.metaStorageManager.registerPrefixWatch(DistributionZonesUtil.zoneDataNodesKey(), this.dataNodesListener);
            CompletableFuture recoveryFinishFuture = this.metaStorageManager.recoveryFinishedFuture();
            assert (recoveryFinishFuture.isDone());
            long recoveryRevision = ((Revisions)recoveryFinishFuture.join()).revision();
            if (IgniteSystemProperties.getBoolean((String)SKIP_REBALANCE_TRIGGERS_RECOVERY, (boolean)false)) {
                return CompletableFutures.nullCompletedFuture();
            }
            if (ENABLED) {
                return this.rebalanceTriggersRecovery(recoveryRevision, catalogVersion).thenCompose(v -> this.distributionZoneRebalanceEngineV2.startAsync());
            }
            return this.rebalanceTriggersRecovery(recoveryRevision, catalogVersion);
        });
    }

    private CompletableFuture<Void> rebalanceTriggersRecovery(long recoveryRevision, int catalogVersion) {
        if (recoveryRevision > 0L) {
            List<CompletableFuture> zonesRecoveryFutures = this.catalogService.zones(catalogVersion).stream().map(zoneDesc -> this.recalculateAssignmentsAndScheduleRebalance((CatalogZoneDescriptor)zoneDesc, recoveryRevision, catalogVersion)).collect(Collectors.toUnmodifiableList());
            return CompletableFuture.allOf(zonesRecoveryFutures.toArray(new CompletableFuture[0]));
        }
        return CompletableFuture.completedFuture(null);
    }

    public void stop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        if (ENABLED) {
            this.distributionZoneRebalanceEngineV2.stop();
        }
        this.metaStorageManager.unregisterWatch(this.dataNodesListener);
    }

    private WatchListener createDistributionZonesDataNodesListener() {
        return evt -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            Set<Node> dataNodes = DistributionZonesUtil.parseDataNodes(evt.entryEvent().newEntry().value());
            if (dataNodes == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            int zoneId = RebalanceUtil.extractZoneId(evt.entryEvent().newEntry().key(), DistributionZonesUtil.DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX_BYTES);
            int catalogVersion = this.catalogService.latestCatalogVersion();
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            long assignmentsTimestamp = catalog.time();
            CatalogZoneDescriptor zoneDescriptor = this.catalogService.zone(zoneId, catalogVersion);
            if (zoneDescriptor == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            Map<UUID, NodeWithAttributes> nodesAttributes = this.distributionZoneManager.nodesAttributes();
            Set<String> filteredDataNodes = DistributionZonesUtil.filterDataNodes(dataNodes, zoneDescriptor, nodesAttributes);
            if (LOG.isInfoEnabled()) {
                ArrayList<NodeWithAttributes> matchedNodes = new ArrayList<NodeWithAttributes>();
                ArrayList<NodeWithAttributes> filteredOutNodes = new ArrayList<NodeWithAttributes>();
                for (Node dataNode : dataNodes) {
                    NodeWithAttributes nodeWithAttributes = nodesAttributes.get(dataNode.nodeId());
                    if (filteredDataNodes.contains(dataNode.nodeName())) {
                        matchedNodes.add(nodeWithAttributes);
                        continue;
                    }
                    filteredOutNodes.add(nodeWithAttributes);
                }
                if (!filteredOutNodes.isEmpty()) {
                    LOG.info("Some data nodes were filtered out because they don't match zone's attributes:\n\tzoneId={}\n\tfilter={}\n\tstorageProfiles={}'\n\tfilteredOutNodes={}\n\tremainingNodes={}", new Object[]{zoneDescriptor.id(), zoneDescriptor.filter(), zoneDescriptor.storageProfiles(), filteredOutNodes, matchedNodes});
                }
            }
            if (filteredDataNodes.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            List<CatalogTableDescriptor> tableDescriptors = DistributionZonesUtil.findTablesByZoneId(zoneId, catalogVersion, this.catalogService);
            return this.triggerPartitionsRebalanceForAllTables(evt.entryEvent().newEntry().revision(), zoneDescriptor, filteredDataNodes, tableDescriptors, assignmentsTimestamp);
        });
    }

    private CompletableFuture<Void> onUpdateReplicas(AlterZoneEventParameters parameters) {
        return this.recalculateAssignmentsAndScheduleRebalance(parameters.zoneDescriptor(), parameters.causalityToken(), parameters.catalogVersion());
    }

    private CompletableFuture<Void> recalculateAssignmentsAndScheduleRebalance(CatalogZoneDescriptor zoneDescriptor, long causalityToken, int catalogVersion) {
        return this.distributionZoneManager.dataNodes(causalityToken, catalogVersion, zoneDescriptor.id()).thenCompose(dataNodes -> {
            if (dataNodes.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            List<CatalogTableDescriptor> tableDescriptors = DistributionZonesUtil.findTablesByZoneId(zoneDescriptor.id(), catalogVersion, this.catalogService);
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            return this.triggerPartitionsRebalanceForAllTables(causalityToken, zoneDescriptor, (Set<String>)dataNodes, tableDescriptors, catalog.time());
        });
    }

    private CompletableFuture<Void> triggerPartitionsRebalanceForAllTables(long revision, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, List<CatalogTableDescriptor> tableDescriptors, long assignmentsTimestamp) {
        ArrayList<CompletableFuture<Void>> tableFutures = new ArrayList<CompletableFuture<Void>>(tableDescriptors.size());
        Set<String> aliveNodes = this.distributionZoneManager.logicalTopology(revision).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
        for (CatalogTableDescriptor tableDescriptor : tableDescriptors) {
            tableFutures.add(RebalanceUtil.triggerAllTablePartitionsRebalance(tableDescriptor, zoneDescriptor, dataNodes, revision, this.metaStorageManager, assignmentsTimestamp, aliveNodes));
        }
        return CompletableFuture.allOf((CompletableFuture[])tableFutures.toArray(CompletableFuture[]::new));
    }
}

