/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.DropZoneEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class SetDefaultZoneEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<SetDefaultZoneEntry> SERIALIZER = new SetDefaultZoneEntrySerializer();
    private final int zoneId;

    public SetDefaultZoneEntry(int zoneId) {
        this.zoneId = zoneId;
    }

    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.SET_DEFAULT_ZONE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SET_DEFAULT_ZONE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new DropZoneEventParameters(causalityToken, catalogVersion, this.zoneId);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), catalog.schemas(), this.zoneId);
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class SetDefaultZoneEntrySerializer
    implements CatalogObjectSerializer<SetDefaultZoneEntry> {
        private SetDefaultZoneEntrySerializer() {
        }

        @Override
        public SetDefaultZoneEntry readFrom(IgniteDataInput input) throws IOException {
            int zoneId = input.readVarIntAsInt();
            return new SetDefaultZoneEntry(zoneId);
        }

        @Override
        public void writeTo(SetDefaultZoneEntry entry, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)entry.zoneId());
        }
    }
}

