/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.presentation;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class HoconPresentation
implements ConfigurationPresentation<String> {
    private final ConfigurationRegistry registry;

    public HoconPresentation(ConfigurationRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String represent() {
        return this.representByPath(null);
    }

    @Override
    public String representByPath(@Nullable String path) {
        return HoconConverter.represent((TraversableTreeNode)this.registry.superRoot(), (List)(path == null ? List.of() : ConfigurationUtil.split((String)path))).render(ConfigRenderOptions.concise());
    }

    @Override
    public CompletableFuture<Void> update(String cfgUpdate) {
        Config config;
        if (cfgUpdate.isBlank()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Empty configuration"));
        }
        try {
            config = ConfigFactory.parseString((String)cfgUpdate);
        }
        catch (ConfigException.Parse e2) {
            return CompletableFuture.failedFuture(new IllegalArgumentException(e2));
        }
        return this.registry.change(HoconConverter.hoconSource((ConfigObject)config.root())).exceptionally(e -> {
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            if (e instanceof IllegalArgumentException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ConfigurationValidationException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ConfigurationChangeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, e);
        });
    }
}

