/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.server.netty.multipart.NettyFileUploadInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Supplier;

@Internal
public class NettyCompletedFileUpload
implements CompletedFileUpload {
    private static final Supplier<ResourceLeakDetector<NettyCompletedFileUpload>> RESOURCE_LEAK_DETECTOR = SupplierUtil.memoized(() -> ResourceLeakDetectorFactory.instance().newResourceLeakDetector(NettyCompletedFileUpload.class));
    private final FileUpload fileUpload;
    private final boolean controlRelease;
    private final ResourceLeakTracker<NettyCompletedFileUpload> tracker;

    public NettyCompletedFileUpload(FileUpload fileUpload) {
        this(fileUpload, true);
    }

    public NettyCompletedFileUpload(FileUpload fileUpload, boolean controlRelease) {
        this.fileUpload = fileUpload;
        this.controlRelease = controlRelease;
        if (controlRelease) {
            fileUpload.retain();
            this.tracker = RESOURCE_LEAK_DETECTOR.get().track((Object)this);
        } else {
            this.tracker = null;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.fileUpload.isInMemory()) {
            ByteBuf byteBuf = this.fileUpload.getByteBuf();
            if (byteBuf == null) {
                throw new IOException("The input stream has already been released");
            }
            this.closeTracker();
            return new ByteBufInputStream(byteBuf, this.controlRelease);
        }
        File file = this.fileUpload.getFile();
        if (file == null) {
            throw new IOException("The input stream has already been released");
        }
        this.closeTracker();
        return new NettyFileUploadInputStream(this.fileUpload, this.controlRelease);
    }

    public byte[] getBytes() throws IOException {
        ByteBuf byteBuf = this.fileUpload.getByteBuf();
        if (byteBuf == null) {
            throw new IOException("The bytes have already been released");
        }
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            return byArray;
        }
        finally {
            this.discard();
        }
    }

    public ByteBuffer getByteBuffer() throws IOException {
        ByteBuf byteBuf = this.fileUpload.getByteBuf();
        if (byteBuf == null) {
            throw new IOException("The byte buffer has already been released");
        }
        try {
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            return byteBuffer;
        }
        finally {
            this.discard();
        }
    }

    public Optional<MediaType> getContentType() {
        return Optional.of(new MediaType(this.fileUpload.getContentType(), NameUtils.extension((String)this.fileUpload.getFilename())));
    }

    public String getName() {
        return this.fileUpload.getName();
    }

    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    public long getSize() {
        return this.fileUpload.length();
    }

    public long getDefinedSize() {
        return this.fileUpload.definedLength();
    }

    public boolean isComplete() {
        return this.fileUpload.isCompleted();
    }

    public final void discard() {
        if (this.controlRelease) {
            this.fileUpload.release();
        }
        this.closeTracker();
    }

    private void closeTracker() {
        if (this.tracker != null) {
            this.tracker.close((Object)this);
        }
    }
}

