/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tostring;

import java.util.Arrays;

class CircularStringBuilder {
    private final char[] buf;
    private int pos;
    private boolean full;
    private int skipped;

    CircularStringBuilder(int capacity) {
        assert (capacity > 0) : "Can't allocate CircularStringBuilder with capacity: " + capacity;
        this.buf = new char[capacity];
        this.pos = 0;
        this.skipped = 0;
        this.full = false;
    }

    public void reset() {
        Arrays.fill(this.buf, '\u0000');
        this.pos = 0;
        this.full = false;
        this.skipped = 0;
    }

    public int length() {
        return this.full ? this.buf.length : this.pos;
    }

    public int capacity() {
        return this.buf.length;
    }

    public CircularStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public CircularStringBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen == 0) {
            return this;
        }
        if (strLen >= this.buf.length) {
            str.getChars(strLen - this.buf.length, strLen, this.buf, 0);
            this.skipped += strLen - this.buf.length + this.pos;
            this.pos = this.buf.length;
            this.full = true;
        } else if (this.buf.length - this.pos < strLen) {
            int firstPart = this.buf.length - this.pos;
            if (firstPart > 0) {
                str.getChars(0, firstPart, this.buf, this.pos);
            }
            str.getChars(firstPart, strLen, this.buf, 0);
            this.skipped += this.full ? strLen : strLen - firstPart;
            this.pos = this.pos + strLen - this.buf.length;
            this.full = true;
        } else {
            str.getChars(0, strLen, this.buf, this.pos);
            this.skipped += this.full ? strLen : 0;
            this.pos += strLen;
        }
        return this;
    }

    public CircularStringBuilder append(StringBuffer sb) {
        if (sb == null) {
            return this.appendNull();
        }
        int strLen = sb.length();
        if (strLen == 0) {
            return this;
        }
        if (strLen >= this.buf.length) {
            sb.getChars(strLen - this.buf.length, strLen, this.buf, 0);
            this.skipped += strLen - this.buf.length + this.pos;
            this.pos = this.buf.length;
            this.full = true;
        } else if (this.buf.length - this.pos < strLen) {
            int firstPart = this.buf.length - this.pos;
            if (firstPart > 0) {
                sb.getChars(0, firstPart, this.buf, this.pos);
            }
            sb.getChars(firstPart, strLen, this.buf, 0);
            this.skipped += this.full ? strLen : strLen - firstPart;
            this.pos = this.pos + strLen - this.buf.length;
            this.full = true;
        } else {
            sb.getChars(0, strLen, this.buf, this.pos);
            this.skipped += this.full ? strLen : 0;
            this.pos += strLen;
        }
        return this;
    }

    public CircularStringBuilder append(StringBuilder sb) {
        if (sb == null) {
            return this.appendNull();
        }
        int strLen = sb.length();
        if (strLen == 0) {
            return this;
        }
        if (strLen >= this.buf.length) {
            sb.getChars(strLen - this.buf.length, strLen, this.buf, 0);
            this.skipped += strLen - this.buf.length + this.pos;
            this.pos = this.buf.length;
            this.full = true;
        } else if (this.buf.length - this.pos < strLen) {
            int firstPart = this.buf.length - this.pos;
            if (firstPart > 0) {
                sb.getChars(0, firstPart, this.buf, this.pos);
            }
            sb.getChars(firstPart, strLen, this.buf, 0);
            this.skipped += this.full ? strLen : strLen - firstPart;
            this.pos = this.pos + strLen - this.buf.length;
            this.full = true;
        } else {
            sb.getChars(0, strLen, this.buf, this.pos);
            this.skipped += this.full ? strLen : 0;
            this.pos += strLen;
        }
        return this;
    }

    private CircularStringBuilder appendNull() {
        return this.append("null");
    }

    public int getSkipped() {
        return this.skipped;
    }

    public String toString() {
        if (this.full && this.pos < this.buf.length) {
            char[] tmpBuf = new char[this.buf.length];
            int tailLen = this.buf.length - this.pos;
            System.arraycopy(this.buf, this.pos, tmpBuf, 0, tailLen);
            System.arraycopy(this.buf, 0, tmpBuf, tailLen, this.buf.length - tailLen);
            return new String(tmpBuf, 0, tmpBuf.length);
        }
        return new String(this.buf, 0, this.pos);
    }
}

