/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.ValueResolver;
import java.util.Map;
import java.util.Optional;

class MapValueResolver<K extends CharSequence>
implements ValueResolver<K> {
    private final Map<K, ?> map;

    MapValueResolver(Map<K, ?> map) {
        this.map = map;
    }

    @Override
    public <T> Optional<T> get(K name, ArgumentConversionContext<T> conversionContext) {
        Object v = this.map.get(name);
        if (v == null) {
            return Optional.empty();
        }
        Argument<T> argument = conversionContext.getArgument();
        if (argument.getType().isInstance(v)) {
            return Optional.of(v);
        }
        return ConversionService.SHARED.convert(v, conversionContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapValueResolver that = (MapValueResolver)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

