/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv.io;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.pagememory.io.AbstractDataPageIo;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.lang.IgniteStringBuilder;
import org.jetbrains.annotations.Nullable;

public class RowVersionDataIo
extends AbstractDataPageIo<RowVersion> {
    public static final short T_VALUE_VERSION_DATA_IO = 12;
    public static final IoVersions<RowVersionDataIo> VERSIONS = new IoVersions((PageIo[])new RowVersionDataIo[]{new RowVersionDataIo(1)});

    protected RowVersionDataIo(int ver) {
        super(12, ver);
    }

    protected void writeRowData(long pageAddr, int dataOff, int payloadSize, RowVersion row, boolean newRow) {
        this.assertPageType(pageAddr);
        long addr = pageAddr + (long)dataOff;
        PageUtils.putShort((long)addr, (int)0, (short)((short)payloadSize));
        addr += 2L;
        addr += (long)HybridTimestamps.writeTimestampToMemory(addr, 0, row.timestamp());
        addr += PartitionlessLinks.writePartitionless((long)addr, (long)row.nextLink());
        PageUtils.putInt((long)addr, (int)0, (int)row.valueSize());
        PageUtils.putByteBuffer((long)(addr += 4L), (int)0, (ByteBuffer)row.value());
    }

    protected void writeFragmentData(RowVersion row, ByteBuffer pageBuf, int rowOff, int payloadSize) {
        this.assertPageType(pageBuf);
        if (rowOff == 0) {
            assert (row.headerSize() <= payloadSize) : "Header must entirely fit in the first fragment, but header size is " + row.headerSize() + " and payload size is " + payloadSize;
            HybridTimestamps.writeTimestampToBuffer(pageBuf, row.timestamp());
            PartitionlessLinks.writeToBuffer((ByteBuffer)pageBuf, (long)row.nextLink());
            pageBuf.putInt(row.valueSize());
            this.putValueBufferIntoPage(pageBuf, row.value(), 0, payloadSize - row.headerSize());
        } else {
            assert (rowOff >= row.headerSize());
            this.putValueBufferIntoPage(pageBuf, row.value(), rowOff - row.headerSize(), payloadSize);
        }
    }

    public void updateTimestamp(long pageAddr, int itemId, int pageSize, @Nullable HybridTimestamp timestamp) {
        int payloadOffset = this.getPayloadOffset(pageAddr, itemId, pageSize, 0);
        HybridTimestamps.writeTimestampToMemory(pageAddr, payloadOffset + 0, timestamp);
    }

    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("RowVersionDataIo [\n");
        this.printPageLayout(addr, pageSize, sb);
        sb.app("\n]");
    }
}

