/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.network.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;

public class ClusterServiceUtils {
    private ClusterServiceUtils() {
    }

    public static List<ClusterNode> resolveNodes(ClusterService clusterService, Collection<String> consistentIds) {
        return consistentIds.stream().map(consistentId -> {
            ClusterNode node = clusterService.topologyService().getByConsistentId(consistentId);
            if (node == null) {
                throw new IllegalArgumentException(String.format("Node \"%s\" is not present in the physical topology", consistentId));
            }
            return node;
        }).collect(Collectors.toList());
    }
}

