/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;

public class ClientResourceRegistry {
    private final Map<Long, ClientResource> res = new ConcurrentHashMap<Long, ClientResource>();
    private final AtomicLong idGen = new AtomicLong();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long put(ClientResource obj) throws IgniteInternalCheckedException {
        this.enter();
        try {
            long id = this.idGen.incrementAndGet();
            this.res.put(id, obj);
            long l = id;
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResource get(long id) throws IgniteInternalCheckedException {
        this.enter();
        try {
            ClientResource res = this.res.get(id);
            if (res == null) {
                throw new IgniteInternalException("Failed to find resource with id: " + id);
            }
            ClientResource clientResource = res;
            return clientResource;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResource remove(long id) throws IgniteInternalCheckedException {
        this.enter();
        try {
            ClientResource res = this.res.remove(id);
            if (res == null) {
                throw new IgniteInternalException("Failed to find resource with id: " + id);
            }
            ClientResource clientResource = res;
            return clientResource;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.rwLock.writeLock().lock();
        try {
            this.closed = true;
            IgniteInternalException ex = null;
            for (ClientResource r : this.res.values()) {
                try {
                    r.release();
                }
                catch (Exception e) {
                    if (ex == null) {
                        ex = new IgniteInternalException((Throwable)e);
                        continue;
                    }
                    ex.addSuppressed((Throwable)e);
                }
            }
            this.res.clear();
            if (ex != null) {
                throw ex;
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void enter() throws IgniteInternalCheckedException {
        if (!this.rwLock.readLock().tryLock() || this.closed) {
            throw new IgniteInternalCheckedException("Resource registry is closed.");
        }
    }

    private void leave() {
        this.rwLock.readLock().unlock();
    }
}

