/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.set;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;

public interface IgniteMapSetOp
extends IgniteSetOp {
    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        boolean rewindable = inputTraits.stream().map(TraitUtils::rewindability).allMatch(RewindabilityTrait::rewindable);
        if (rewindable) {
            return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.REWINDABLE), inputTraits));
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.ONE_WAY), Commons.transform(inputTraits, t -> t.replace((RelTrait)RewindabilityTrait.ONE_WAY))));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        if (inputTraits.stream().allMatch(t -> TraitUtils.distribution(t).satisfies((RelTrait)IgniteDistributions.single()))) {
            return List.of();
        }
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.random()), Commons.transform(inputTraits, t -> TraitUtils.distribution(t) == IgniteDistributions.broadcast() ? t.replace((RelTrait)IgniteDistributions.hash(List.of(Integer.valueOf(0)))) : t.replace((RelTrait)IgniteDistributions.random()))));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> correlationIds = inTraits.stream().map(TraitUtils::correlation).flatMap(corrTr -> corrTr.correlationIds().stream()).collect(Collectors.toSet());
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(correlationIds)), inTraits));
    }

    default public RelDataType buildRowType() {
        IgniteTypeFactory typeFactory = Commons.typeFactory(this.getCluster());
        if (!1.$assertionsDisabled && !(typeFactory instanceof IgniteTypeFactory)) {
            throw new AssertionError();
        }
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        builder.add("GROUP_KEY", typeFactory.createJavaType(GroupKey.class));
        builder.add("COUNTERS", typeFactory.createJavaType(int[].class));
        return builder.build();
    }

    @Override
    default public AggregateType aggregateType() {
        return AggregateType.MAP;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

