/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.thread.LogUncaughtExceptionHandler;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.thread.StripedThreadPoolExecutor;
import org.apache.ignite.internal.util.IgniteUtils;

public class QueryTaskExecutorImpl
implements QueryTaskExecutor,
Thread.UncaughtExceptionHandler {
    private static final IgniteLogger LOG = Loggers.forClass(QueryTaskExecutorImpl.class);
    private static final UUID QUERY_ID_STUB = UUID.randomUUID();
    private final String nodeName;
    private volatile StripedThreadPoolExecutor stripedThreadPoolExecutor;
    private Thread.UncaughtExceptionHandler exHnd;

    public QueryTaskExecutorImpl(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public void start() {
        this.stripedThreadPoolExecutor = new StripedThreadPoolExecutor(4, NamedThreadFactory.threadPrefix((String)this.nodeName, (String)"sql-execution-pool"), (Thread.UncaughtExceptionHandler)new LogUncaughtExceptionHandler(LOG), false, 0L);
    }

    public void exceptionHandler(Thread.UncaughtExceptionHandler exHnd) {
        this.exHnd = exHnd;
    }

    @Override
    public void execute(UUID qryId, long fragmentId, Runnable qryTask) {
        this.stripedThreadPoolExecutor.execute(() -> {
            try {
                qryTask.run();
            }
            catch (Throwable e) {
                LOG.debug("Uncaught exception", e);
                this.uncaughtException(Thread.currentThread(), e);
            }
        }, QueryTaskExecutorImpl.hash(qryId, fragmentId));
    }

    @Override
    public void execute(Runnable command) {
        this.execute(QUERY_ID_STUB, ThreadLocalRandom.current().nextLong(1024L), command);
    }

    @Override
    public CompletableFuture<?> submit(UUID qryId, long fragmentId, Runnable qryTask) {
        return this.stripedThreadPoolExecutor.submit(qryTask, QueryTaskExecutorImpl.hash(qryId, fragmentId));
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.exHnd != null) {
            this.exHnd.uncaughtException(t, e);
        }
    }

    private static int hash(UUID qryId, long fragmentId) {
        return IgniteUtils.safeAbs((int)(31 * (31 + (qryId != null ? qryId.hashCode() : 0)) + Long.hashCode(fragmentId)));
    }

    @Override
    public void stop() {
        if (this.stripedThreadPoolExecutor != null) {
            this.stripedThreadPoolExecutor.shutdownNow();
        }
    }
}

