/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.schema.configuration.TablesView;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.index.HashIndexDescriptor;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.rocksdb.ColumnFamilyUtils;
import org.apache.ignite.internal.storage.rocksdb.HashIndex;
import org.apache.ignite.internal.storage.rocksdb.RocksDbDataRegion;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageEngine;
import org.apache.ignite.internal.storage.rocksdb.SortedIndex;
import org.apache.ignite.internal.storage.rocksdb.index.RocksDbBinaryTupleComparator;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksDbTableStorage
implements MvTableStorage {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbTableStorage.class);
    private final RocksDbStorageEngine engine;
    private final Path tablePath;
    private final TableConfiguration tableCfg;
    private final TablesConfiguration tablesCfg;
    private final RocksDbDataRegion dataRegion;
    private volatile RocksDbFlusher flusher;
    private volatile RocksDB db;
    private final WriteOptions writeOptions = new WriteOptions().setDisableWAL(true);
    private volatile RocksDbMetaStorage meta;
    private volatile ColumnFamily partitionCf;
    private volatile ColumnFamily hashIndexCf;
    private volatile AtomicReferenceArray<RocksDbMvPartitionStorage> partitions;
    private final ConcurrentMap<UUID, HashIndex> hashIndices = new ConcurrentHashMap<UUID, HashIndex>();
    private final ConcurrentMap<UUID, SortedIndex> sortedIndices = new ConcurrentHashMap<UUID, SortedIndex>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    RocksDbTableStorage(RocksDbStorageEngine engine, Path tablePath, RocksDbDataRegion dataRegion, TableConfiguration tableCfg, TablesConfiguration tablesCfg) {
        this.engine = engine;
        this.tablePath = tablePath;
        this.tableCfg = tableCfg;
        this.dataRegion = dataRegion;
        this.tablesCfg = tablesCfg;
    }

    public RocksDbStorageEngine engine() {
        return this.engine;
    }

    public RocksDB db() {
        return this.db;
    }

    public ColumnFamilyHandle partitionCfHandle() {
        return this.partitionCf.handle();
    }

    public ColumnFamilyHandle metaCfHandle() {
        return this.meta.columnFamily().handle();
    }

    public TableConfiguration configuration() {
        return this.tableCfg;
    }

    public TablesConfiguration tablesConfiguration() {
        return this.tablesCfg;
    }

    public void start() throws StorageException {
        this.flusher = new RocksDbFlusher(this.busyLock, this.engine.scheduledPool(), this.engine().threadPool(), () -> this.engine.configuration().flushDelayMillis().value(), this::refreshPersistedIndexes);
        try {
            Files.createDirectories(this.tablePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new StorageException("Failed to create a directory for the table storage", (Throwable)e);
        }
        List<ColumnFamilyDescriptor> cfDescriptors = this.getExistingCfDescriptors();
        ArrayList cfHandles = new ArrayList(cfDescriptors.size());
        DBOptions dbOptions = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setAtomicFlush(true).setListeners(List.of(this.flusher.listener())).setWriteBufferManager(this.dataRegion.writeBufferManager());
        try {
            this.db = RocksDB.open((DBOptions)dbOptions, (String)this.tablePath.toAbsolutePath().toString(), cfDescriptors, cfHandles);
            block10: for (ColumnFamilyHandle cfHandle : cfHandles) {
                ColumnFamily cf = ColumnFamily.wrap((RocksDB)this.db, (ColumnFamilyHandle)cfHandle);
                switch (ColumnFamilyUtils.ColumnFamilyType.fromCfName(cf.name())) {
                    case META: {
                        this.meta = new RocksDbMetaStorage(cf);
                        continue block10;
                    }
                    case PARTITION: {
                        this.partitionCf = cf;
                        continue block10;
                    }
                    case HASH_INDEX: {
                        this.hashIndexCf = cf;
                        continue block10;
                    }
                    case SORTED_INDEX: {
                        UUID indexId = ColumnFamilyUtils.sortedIndexId(cf.name());
                        SortedIndexDescriptor indexDescriptor = new SortedIndexDescriptor(indexId, (TablesView)this.tablesCfg.value());
                        this.sortedIndices.put(indexId, new SortedIndex(cf, indexDescriptor));
                        continue block10;
                    }
                }
                throw new StorageException("Unidentified column family [name=" + cf.name() + ", table=" + ((TableView)this.tableCfg.value()).name() + "]");
            }
            assert (this.meta != null);
            assert (this.partitionCf != null);
            assert (this.hashIndexCf != null);
            this.flusher.init(this.db, cfHandles);
        }
        catch (RocksDBException e) {
            throw new StorageException("Failed to initialize RocksDB instance", (Throwable)e);
        }
        this.partitions = new AtomicReferenceArray(((TableView)this.tableCfg.value()).partitions());
        for (Object partId : (Object)this.meta.getPartitionIds()) {
            this.partitions.set((int)partId, new RocksDbMvPartitionStorage(this, (int)partId));
        }
    }

    public CompletableFuture<Void> awaitFlush(boolean schedule) {
        return this.flusher.awaitFlush(schedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPersistedIndexes() {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            TableView tableCfgView = (TableView)this.configuration().value();
            for (int partitionId = 0; partitionId < tableCfgView.partitions(); ++partitionId) {
                RocksDbMvPartitionStorage partition = this.getMvPartition(partitionId);
                if (partition == null) continue;
                try {
                    partition.refreshPersistedIndex();
                    continue;
                }
                catch (StorageException storageException) {
                    LOG.error("Filed to refresh persisted applied index value for table {} partition {}", (Throwable)storageException, new Object[]{this.configuration().name().value(), partitionId});
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void stop() throws StorageException {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
        resources.add(() -> ((RocksDbFlusher)this.flusher).stop());
        resources.add((AutoCloseable)this.meta.columnFamily().handle());
        resources.add((AutoCloseable)this.partitionCf.handle());
        resources.add((AutoCloseable)this.hashIndexCf.handle());
        resources.addAll(this.sortedIndices.values());
        resources.add((AutoCloseable)this.db);
        resources.add((AutoCloseable)this.writeOptions);
        for (int i = 0; i < this.partitions.length(); ++i) {
            MvPartitionStorage partition = this.partitions.get(i);
            if (partition == null) continue;
            resources.add((AutoCloseable)partition);
        }
        Collections.reverse(resources);
        try {
            IgniteUtils.closeAll(resources);
        }
        catch (Exception e) {
            throw new StorageException("Failed to stop RocksDB table storage.", (Throwable)e);
        }
    }

    public void destroy() throws StorageException {
        this.stop();
        IgniteUtils.deleteIfExists((Path)this.tablePath);
    }

    public RocksDbMvPartitionStorage getOrCreateMvPartition(int partitionId) throws StorageException {
        RocksDbMvPartitionStorage partition = this.getMvPartition(partitionId);
        if (partition != null) {
            return partition;
        }
        partition = new RocksDbMvPartitionStorage(this, partitionId);
        this.partitions.set(partitionId, partition);
        this.meta.putPartitionId(partitionId);
        return partition;
    }

    @Nullable
    public RocksDbMvPartitionStorage getMvPartition(int partitionId) {
        this.checkPartitionId(partitionId);
        return this.partitions.get(partitionId);
    }

    public CompletableFuture<Void> destroyPartition(int partitionId) throws StorageException {
        this.checkPartitionId(partitionId);
        RocksDbMvPartitionStorage mvPartition = this.partitions.getAndSet(partitionId, null);
        if (mvPartition == null) {
            return CompletableFuture.completedFuture(null);
        }
        mvPartition.destroy();
        return this.awaitFlush(false).whenComplete((v, e) -> {
            try {
                mvPartition.close();
            }
            catch (Exception ex) {
                LOG.error("Error when closing partition storage for partId = {}", (Throwable)ex, new Object[]{partitionId});
            }
        });
    }

    public SortedIndexStorage getOrCreateSortedIndex(int partitionId, UUID indexId) {
        SortedIndex storages = this.sortedIndices.computeIfAbsent(indexId, this::createSortedIndex);
        RocksDbMvPartitionStorage partitionStorage = this.getMvPartition(partitionId);
        if (partitionStorage == null) {
            throw new StorageException(String.format("Partition ID %d does not exist", partitionId));
        }
        return storages.getOrCreateStorage(partitionStorage);
    }

    private SortedIndex createSortedIndex(UUID indexId) {
        ColumnFamily columnFamily;
        SortedIndexDescriptor indexDescriptor = new SortedIndexDescriptor(indexId, (TablesView)this.tablesCfg.value());
        ColumnFamilyDescriptor cfDescriptor = RocksDbTableStorage.sortedIndexCfDescriptor(ColumnFamilyUtils.sortedIndexCfName(indexId), indexDescriptor);
        try {
            columnFamily = ColumnFamily.create((RocksDB)this.db, (ColumnFamilyDescriptor)cfDescriptor);
        }
        catch (RocksDBException e) {
            throw new StorageException("Failed to create new RocksDB column family: " + new String(cfDescriptor.getName(), StandardCharsets.UTF_8), (Throwable)e);
        }
        this.flusher.addColumnFamily(columnFamily.handle());
        return new SortedIndex(columnFamily, indexDescriptor);
    }

    public HashIndexStorage getOrCreateHashIndex(int partitionId, UUID indexId) {
        HashIndex storages = this.hashIndices.computeIfAbsent(indexId, id -> {
            HashIndexDescriptor indexDescriptor = new HashIndexDescriptor(indexId, (TablesView)this.tablesCfg.value());
            return new HashIndex(this.hashIndexCf, indexDescriptor);
        });
        RocksDbMvPartitionStorage partitionStorage = this.getMvPartition(partitionId);
        if (partitionStorage == null) {
            throw new StorageException(String.format("Partition ID %d does not exist", partitionId));
        }
        return storages.getOrCreateStorage(partitionStorage);
    }

    public CompletableFuture<Void> destroyIndex(UUID indexId) {
        SortedIndex sortedIdx;
        HashIndex hashIdx = (HashIndex)this.hashIndices.remove(indexId);
        if (hashIdx != null) {
            hashIdx.destroy();
        }
        if ((sortedIdx = (SortedIndex)this.sortedIndices.remove(indexId)) != null) {
            this.flusher.removeColumnFamily(sortedIdx.indexCf().handle());
            sortedIdx.destroy();
        }
        if (hashIdx == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.awaitFlush(false);
    }

    public boolean isVolatile() {
        return false;
    }

    private void checkPartitionId(int partId) {
        if (partId < 0 || partId >= this.partitions.length()) {
            throw new IllegalArgumentException(S.toString((String)"Unable to access partition with id outside of configured range", (String)"table", (Object)((TableView)this.tableCfg.value()).name(), (boolean)false, (String)"partitionId", (Object)partId, (boolean)false, (String)"partitions", (Object)this.partitions.length(), (boolean)false));
        }
    }

    private List<String> getExistingCfNames() {
        List<String> list;
        String absolutePathStr = this.tablePath.toAbsolutePath().toString();
        Options opts = new Options();
        try {
            List<String> existingNames = RocksDB.listColumnFamilies((Options)opts, (String)absolutePathStr).stream().map(cfNameBytes -> new String((byte[])cfNameBytes, StandardCharsets.UTF_8)).collect(Collectors.toList());
            list = existingNames.isEmpty() ? List.of(ColumnFamilyUtils.META_CF_NAME, "cf-part", "cf-hash") : existingNames;
        }
        catch (Throwable throwable) {
            try {
                try {
                    opts.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RocksDBException e) {
                throw new StorageException("Failed to read list of column families names for the RocksDB instance located at path " + absolutePathStr, (Throwable)e);
            }
        }
        opts.close();
        return list;
    }

    private List<ColumnFamilyDescriptor> getExistingCfDescriptors() {
        return this.getExistingCfNames().stream().map(this::cfDescriptorFromName).collect(Collectors.toList());
    }

    private ColumnFamilyDescriptor cfDescriptorFromName(String cfName) {
        switch (ColumnFamilyUtils.ColumnFamilyType.fromCfName(cfName)) {
            case META: 
            case PARTITION: {
                return new ColumnFamilyDescriptor(cfName.getBytes(StandardCharsets.UTF_8), new ColumnFamilyOptions());
            }
            case HASH_INDEX: {
                return new ColumnFamilyDescriptor(cfName.getBytes(StandardCharsets.UTF_8), new ColumnFamilyOptions().useFixedLengthPrefixExtractor(22));
            }
            case SORTED_INDEX: {
                SortedIndexDescriptor indexDescriptor = new SortedIndexDescriptor(ColumnFamilyUtils.sortedIndexId(cfName), (TablesView)this.tablesCfg.value());
                return RocksDbTableStorage.sortedIndexCfDescriptor(cfName, indexDescriptor);
            }
        }
        throw new StorageException("Unidentified column family [name=" + cfName + ", table=" + ((TableView)this.tableCfg.value()).name() + "]");
    }

    private static ColumnFamilyDescriptor sortedIndexCfDescriptor(String cfName, SortedIndexDescriptor descriptor) {
        RocksDbBinaryTupleComparator comparator = new RocksDbBinaryTupleComparator(descriptor);
        ColumnFamilyOptions options = new ColumnFamilyOptions().setComparator((AbstractComparator)comparator);
        return new ColumnFamilyDescriptor(cfName.getBytes(StandardCharsets.UTF_8), options);
    }
}

