/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.client.ClientOperationType;
import org.apache.ignite.lang.IgniteException;

public class ClientUtils {
    public static <T> T sync(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IgniteException.wrap((Throwable)e);
        }
        catch (ExecutionException e) {
            throw IgniteException.wrap((Throwable)e);
        }
    }

    public static ClientOperationType opCodeToClientOperationType(int opCode) {
        if (opCode < 0) {
            return null;
        }
        switch (opCode) {
            case 1: {
                return null;
            }
            case 3: {
                return ClientOperationType.TABLES_GET;
            }
            case 4: {
                return ClientOperationType.TABLE_GET;
            }
            case 5: {
                return null;
            }
            case 10: {
                return ClientOperationType.TUPLE_UPSERT;
            }
            case 12: {
                return ClientOperationType.TUPLE_GET;
            }
            case 13: {
                return ClientOperationType.TUPLE_UPSERT_ALL;
            }
            case 15: {
                return ClientOperationType.TUPLE_GET_ALL;
            }
            case 16: {
                return ClientOperationType.TUPLE_GET_AND_UPSERT;
            }
            case 18: {
                return ClientOperationType.TUPLE_INSERT;
            }
            case 20: {
                return ClientOperationType.TUPLE_INSERT_ALL;
            }
            case 22: {
                return ClientOperationType.TUPLE_REPLACE;
            }
            case 24: {
                return ClientOperationType.TUPLE_REPLACE_EXACT;
            }
            case 26: {
                return ClientOperationType.TUPLE_GET_AND_REPLACE;
            }
            case 28: {
                return ClientOperationType.TUPLE_DELETE;
            }
            case 29: {
                return ClientOperationType.TUPLE_DELETE_ALL;
            }
            case 30: {
                return ClientOperationType.TUPLE_DELETE_EXACT;
            }
            case 31: {
                return ClientOperationType.TUPLE_DELETE_ALL_EXACT;
            }
            case 32: {
                return ClientOperationType.TUPLE_GET_AND_DELETE;
            }
            case 33: {
                return ClientOperationType.TUPLE_CONTAINS_KEY;
            }
            case 34: {
                return null;
            }
            case 35: {
                return null;
            }
            case 36: {
                return null;
            }
            case 37: {
                return null;
            }
            case 38: {
                return null;
            }
            case 39: {
                return null;
            }
            case 40: {
                return null;
            }
            case 41: {
                return null;
            }
            case 42: {
                return null;
            }
            case 43: 
            case 44: 
            case 45: {
                return null;
            }
            case 46: {
                return null;
            }
            case 47: 
            case 49: {
                return ClientOperationType.COMPUTE_EXECUTE;
            }
            case 48: {
                return null;
            }
            case 50: {
                return ClientOperationType.SQL_EXECUTE;
            }
            case 51: {
                return ClientOperationType.SQL_CURSOR_NEXT_PAGE;
            }
            case 52: {
                return null;
            }
            case 53: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Invalid op code: " + opCode);
    }
}

