/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.questions;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import org.apache.ignite.internal.cli.call.connect.ConnectCall;
import org.apache.ignite.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.config.StateConfigProvider;
import org.apache.ignite.internal.cli.core.flow.builder.FlowBuilder;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.core.repl.Session;
import org.apache.ignite.internal.cli.core.style.component.QuestionUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElements;

@Singleton
public class ConnectToClusterQuestion {
    @Inject
    private ConnectCall connectCall;
    @Inject
    private ConfigManagerProvider configManagerProvider;
    @Inject
    private StateConfigProvider stateConfigProvider;
    @Inject
    private Session session;

    public FlowBuilder<Void, String> askQuestionIfNotConnected(String clusterUrl) {
        String defaultUrl = this.configManagerProvider.get().getCurrentProperty("ignite.cluster-endpoint-url");
        QuestionUiComponent questionUiComponent = QuestionUiComponent.fromQuestion("You are not connected to node. Do you want to connect to the default node %s? %s ", UiElements.url(defaultUrl), UiElements.yesNo());
        return Flows.from(this.clusterUrlOrSessionNode(clusterUrl)).flatMap(v -> {
            if (Objects.isNull(v)) {
                return Flows.acceptQuestion(questionUiComponent, () -> new ConnectCallInput(defaultUrl)).then(Flows.fromCall(this.connectCall)).print().map(ignored -> this.clusterUrlOrSessionNode(clusterUrl));
            }
            return Flows.identity();
        });
    }

    private String clusterUrlOrSessionNode(String clusterUrl) {
        return clusterUrl != null ? clusterUrl : this.session.nodeUrl();
    }

    public void askQuestionOnReplStart() {
        String clusterUrl;
        QuestionUiComponent question;
        String defaultUrl = this.configManagerProvider.get().getCurrentProperty("ignite.cluster-endpoint-url");
        String lastConnectedUrl = this.stateConfigProvider.get().getProperty("ignite.last-connected-url");
        if (lastConnectedUrl != null) {
            question = QuestionUiComponent.fromQuestion("Do you want to connect to the last connected node %s? %s ", UiElements.url(lastConnectedUrl), UiElements.yesNo());
            clusterUrl = lastConnectedUrl;
        } else if (defaultUrl != null) {
            question = QuestionUiComponent.fromQuestion("Do you want to connect to the default node %s? %s ", UiElements.url(defaultUrl), UiElements.yesNo());
            clusterUrl = defaultUrl;
        } else {
            return;
        }
        Flows.acceptQuestion(question, () -> new ConnectCallInput(clusterUrl)).then(Flows.fromCall(this.connectCall)).print().ifThen(s -> !Objects.equals(clusterUrl, defaultUrl) && this.session.isConnectedToNode(), this.defaultUrlQuestion(clusterUrl).print().build()).start();
    }

    private FlowBuilder<String, String> defaultUrlQuestion(String lastConnectedUrl) {
        return Flows.acceptQuestion(QuestionUiComponent.fromQuestion("Would you like to use %s as the default URL? %s ", UiElements.url(lastConnectedUrl), UiElements.yesNo()), () -> {
            this.configManagerProvider.get().setProperty("ignite.cluster-endpoint-url", lastConnectedUrl);
            return "Config saved";
        });
    }
}

