/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryDataRegionConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryDataRegionView;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.PageReadWriteManager;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.storage.StorageException;

class PersistentPageMemoryDataRegion
implements DataRegion<PersistentPageMemory> {
    private static final double PAGE_LIST_CACHE_LIMIT_THRESHOLD = 0.1;
    private final PersistentPageMemoryDataRegionConfiguration cfg;
    private final PageIoRegistry ioRegistry;
    private final int pageSize;
    private final FilePageStoreManager filePageStoreManager;
    private final PartitionMetaManager partitionMetaManager;
    private final CheckpointManager checkpointManager;
    private volatile PersistentPageMemory pageMemory;
    private volatile AtomicLong pageListCacheLimit;

    public PersistentPageMemoryDataRegion(PersistentPageMemoryDataRegionConfiguration cfg, PageIoRegistry ioRegistry, FilePageStoreManager filePageStoreManager, PartitionMetaManager partitionMetaManager, CheckpointManager checkpointManager, int pageSize) {
        this.cfg = cfg;
        this.ioRegistry = ioRegistry;
        this.pageSize = pageSize;
        this.filePageStoreManager = filePageStoreManager;
        this.partitionMetaManager = partitionMetaManager;
        this.checkpointManager = checkpointManager;
    }

    public void start() {
        PersistentPageMemoryDataRegionView dataRegionConfigView = (PersistentPageMemoryDataRegionView)this.cfg.value();
        PersistentPageMemory pageMemory = new PersistentPageMemory(this.cfg, this.ioRegistry, PersistentPageMemoryDataRegion.calculateSegmentSizes(dataRegionConfigView, Runtime.getRuntime().availableProcessors()), PersistentPageMemoryDataRegion.calculateCheckpointBufferSize(dataRegionConfigView), (PageReadWriteManager)this.filePageStoreManager, null, (pageMemory0, fullPageId, buf) -> this.checkpointManager.writePageToDeltaFilePageStore(pageMemory0, fullPageId, buf, true), this.checkpointManager.checkpointTimeoutLock(), this.pageSize);
        pageMemory.start();
        this.pageListCacheLimit = new AtomicLong((long)((double)pageMemory.totalPages() * 0.1));
        this.pageMemory = pageMemory;
    }

    public void stop() throws Exception {
        if (this.pageMemory != null) {
            this.pageMemory.stop(true);
        }
    }

    public PersistentPageMemory pageMemory() {
        this.checkDataRegionStarted();
        return this.pageMemory;
    }

    public FilePageStoreManager filePageStoreManager() {
        return this.filePageStoreManager;
    }

    public PartitionMetaManager partitionMetaManager() {
        return this.partitionMetaManager;
    }

    public CheckpointManager checkpointManager() {
        return this.checkpointManager;
    }

    public AtomicLong pageListCacheLimit() {
        this.checkDataRegionStarted();
        return this.pageListCacheLimit;
    }

    static long[] calculateSegmentSizes(PersistentPageMemoryDataRegionView dataRegionConfigView, int concurrencyLevel) {
        assert (concurrencyLevel > 0) : concurrencyLevel;
        long maxSize = dataRegionConfigView.size();
        long fragmentSize = Math.max(maxSize / (long)concurrencyLevel, 0x100000L);
        long[] sizes = new long[concurrencyLevel];
        Arrays.fill(sizes, fragmentSize);
        return sizes;
    }

    static long calculateCheckpointBufferSize(PersistentPageMemoryDataRegionView dataRegionConfigView) {
        long maxSize = dataRegionConfigView.size();
        if (maxSize < 0x40000000L) {
            return Math.min(0x10000000L, maxSize);
        }
        if (maxSize < 0x200000000L) {
            return maxSize / 4L;
        }
        return 0x80000000L;
    }

    private void checkDataRegionStarted() {
        if (this.pageMemory == null) {
            throw new StorageException("Data region not started");
        }
    }
}

