/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.worker.IgniteWorker;

class LongOperationAsyncExecutor {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String igniteInstanceName;
    private final IgniteLogger log;
    private final Set<IgniteWorker> workers = ConcurrentHashMap.newKeySet();
    private static final AtomicLong WORKER_COUNTER = new AtomicLong(0L);

    public LongOperationAsyncExecutor(String igniteInstanceName, IgniteLogger log) {
        this.igniteInstanceName = igniteInstanceName;
        this.log = log;
    }

    public void async(final Runnable operation, String name) {
        String workerName = "async-" + name + "-task-" + WORKER_COUNTER.getAndIncrement();
        IgniteWorker worker = new IgniteWorker(this.log, this.igniteInstanceName, workerName, null){

            protected void body() {
                LongOperationAsyncExecutor.this.readWriteLock.writeLock().lock();
                try {
                    operation.run();
                }
                finally {
                    LongOperationAsyncExecutor.this.readWriteLock.writeLock().unlock();
                    LongOperationAsyncExecutor.this.workers.remove((Object)this);
                }
            }
        };
        this.workers.add(worker);
        new IgniteThread(worker).start();
    }

    public <T> T afterAsyncCompletion(Supplier<T> supplier) {
        this.readWriteLock.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void awaitAsyncTaskCompletion(boolean cancel) {
        IgniteUtils.awaitForWorkersStop(this.workers, (boolean)cancel, (IgniteLogger)this.log);
    }
}

