/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.util.ArrayFactory;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtils {
    public static final byte[] BYTE_EMPTY_ARRAY = new byte[0];
    public static final short[] SHORT_EMPTY_ARRAY = new short[0];
    public static final int[] INT_EMPTY_ARRAY = new int[0];
    public static final long[] LONG_EMPTY_ARRAY = new long[0];
    public static final float[] FLOAT_EMPTY_ARRAY = new float[0];
    public static final double[] DOUBLE_EMPTY_ARRAY = new double[0];
    public static final char[] CHAR_EMPTY_ARRAY = new char[0];
    public static final boolean[] BOOLEAN_EMPTY_ARRAY = new boolean[0];
    public static final Object[] OBJECT_EMPTY_ARRAY = new Object[0];
    public static final String[] STRING_EMPTY_ARRAY = new String[0];
    public static final ArrayFactory<byte[]> BYTE_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid byte array length: " + len);
        }
        switch (len) {
            case 0: {
                return BYTE_EMPTY_ARRAY;
            }
        }
        return new byte[len];
    };
    public static final ArrayFactory<short[]> SHORT_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid short array length: " + len);
        }
        switch (len) {
            case 0: {
                return SHORT_EMPTY_ARRAY;
            }
        }
        return new short[len];
    };
    public static final ArrayFactory<int[]> INT_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid int array length: " + len);
        }
        switch (len) {
            case 0: {
                return INT_EMPTY_ARRAY;
            }
        }
        return new int[len];
    };
    public static final ArrayFactory<long[]> LONG_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid long array length: " + len);
        }
        switch (len) {
            case 0: {
                return LONG_EMPTY_ARRAY;
            }
        }
        return new long[len];
    };
    public static final ArrayFactory<float[]> FLOAT_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid float array length: " + len);
        }
        switch (len) {
            case 0: {
                return FLOAT_EMPTY_ARRAY;
            }
        }
        return new float[len];
    };
    public static final ArrayFactory<double[]> DOUBLE_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid double array length: " + len);
        }
        switch (len) {
            case 0: {
                return DOUBLE_EMPTY_ARRAY;
            }
        }
        return new double[len];
    };
    public static final ArrayFactory<char[]> CHAR_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid char array length: " + len);
        }
        switch (len) {
            case 0: {
                return CHAR_EMPTY_ARRAY;
            }
        }
        return new char[len];
    };
    public static final ArrayFactory<boolean[]> BOOLEAN_ARRAY = len -> {
        if (len < 0) {
            throw new IgniteInternalException("Read invalid boolean array length: " + len);
        }
        switch (len) {
            case 0: {
                return BOOLEAN_EMPTY_ARRAY;
            }
        }
        return new boolean[len];
    };

    public static <T> boolean nullOrEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean nullOrEmpty(byte[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean nullOrEmpty(short[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean nullOrEmpty(int[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean nullOrEmpty(long[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean nullOrEmpty(float[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean nullOrEmpty(double[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean nullOrEmpty(boolean[] arr) {
        return arr == null || arr.length == 0;
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... vals) {
        return ArrayUtils.nullOrEmpty(vals) ? Collections.emptyList() : List.of(vals);
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... vals) {
        if (ArrayUtils.nullOrEmpty(vals)) {
            return Collections.emptySet();
        }
        return Set.of(vals);
    }

    @SafeVarargs
    public static <T> T[] concat(@Nullable T[] arr, T ... obj) {
        T[] newArr;
        if (arr == null || arr.length == 0) {
            newArr = obj;
        } else {
            newArr = Arrays.copyOf(arr, arr.length + obj.length);
            System.arraycopy(obj, 0, newArr, arr.length, obj.length);
        }
        return newArr;
    }

    public static long[] concat(@Nullable long[] arr, long ... longs) {
        if (ArrayUtils.nullOrEmpty(arr)) {
            return longs;
        }
        long[] newArr = Arrays.copyOf(arr, arr.length + longs.length);
        System.arraycopy(longs, 0, newArr, arr.length, longs.length);
        return newArr;
    }

    public static <T> T[] remove(T[] arr, int idx) {
        int len = arr.length;
        assert (idx >= 0 && idx < len) : idx + " < " + len;
        if (idx < len >>> 1) {
            T[] res = Arrays.copyOfRange(arr, 1, len);
            System.arraycopy(arr, 0, res, 0, idx);
            return res;
        }
        T[] res = Arrays.copyOf(arr, len - 1);
        System.arraycopy(arr, idx + 1, res, idx, len - idx - 1);
        return res;
    }

    public static long[] remove(long[] arr, int idx) {
        int len = arr.length;
        assert (idx >= 0 && idx < len) : idx + " < " + len;
        if (idx < len >>> 1) {
            long[] res = Arrays.copyOfRange(arr, 1, len);
            System.arraycopy(arr, 0, res, 0, idx);
            return res;
        }
        long[] res = Arrays.copyOf(arr, len - 1);
        System.arraycopy(arr, idx + 1, res, idx, len - idx - 1);
        return res;
    }

    public static <T> T[] set(T[] arr, int idx, T o) {
        int len = arr.length;
        if (idx >= len) {
            len += len >>> 1;
            len = Math.max(len, idx + 1);
            arr = Arrays.copyOf(arr, len);
        }
        arr[idx] = o;
        return arr;
    }

    public static void clearTail(Object[] arr, int fromIdx) {
        while (fromIdx < arr.length && arr[fromIdx] != null) {
            arr[fromIdx++] = null;
        }
    }
}

