/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.row;

import java.time.LocalDate;
import java.time.LocalTime;
import org.apache.ignite.internal.schema.TemporalNativeType;

public class TemporalTypesHelper {
    public static final int MONTH_FIELD_LENGTH = 4;
    public static final int DAY_FIELD_LENGTH = 5;
    public static final int HOUR_FIELD_LENGTH = 5;
    public static final int MINUTES_FIELD_LENGTH = 6;
    public static final int SECONDS_FIELD_LENGTH = 6;
    public static final int MAX_YEAR = 16383;
    public static final int MIN_YEAR = -16384;
    public static final int MILLISECOND_PART_LEN = 14;
    public static final long MILLISECOND_PART_MASK = 16383L;
    public static final int NANOSECOND_PART_LEN = 30;
    public static final long NANOSECOND_PART_MASK = 0x3FFFFFFFL;

    private static int mask(int len) {
        return (1 << len) - 1;
    }

    public static int encodeDate(LocalDate date) {
        int val = date.getYear() << 4;
        val = (val | date.getMonthValue()) << 5;
        return (val |= date.getDayOfMonth()) & 0xFFFFFF;
    }

    public static LocalDate decodeDate(int date) {
        date = date << 8 >> 8;
        int day = date & TemporalTypesHelper.mask(5);
        int mon = (date >>= 5) & TemporalTypesHelper.mask(4);
        int year = date >> 4;
        return LocalDate.of(year, mon, day);
    }

    public static long encodeTime(TemporalNativeType type, LocalTime localTime) {
        int time = localTime.getHour() << 12;
        time |= localTime.getMinute() << 6;
        int fractional = TemporalTypesHelper.truncateTo(type.precision(), localTime.getNano());
        return (long)(time |= localTime.getSecond()) << 32 | (long)fractional;
    }

    public static LocalTime decodeTime(TemporalNativeType type, long time) {
        int fractional = (int)time;
        int time0 = (int)(time >>> 32);
        int sec = time0 & TemporalTypesHelper.mask(6);
        int min = (time0 >>>= 6) & TemporalTypesHelper.mask(6);
        int hour = time0 >>> 6 & TemporalTypesHelper.mask(5);
        switch (type.precision()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                fractional *= 1000000;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                fractional *= 1000;
                break;
            }
        }
        return LocalTime.of(hour, min, sec, fractional);
    }

    public static int normalizeNanos(int nanos, int precision) {
        switch (precision) {
            case 0: {
                nanos = 0;
                break;
            }
            case 1: {
                nanos = nanos / 100000000 * 100000000;
                break;
            }
            case 2: {
                nanos = nanos / 10000000 * 10000000;
                break;
            }
            case 3: {
                nanos = nanos / 1000000 * 1000000;
                break;
            }
            case 4: {
                nanos = nanos / 100000 * 100000;
                break;
            }
            case 5: {
                nanos = nanos / 10000 * 10000;
                break;
            }
            case 6: {
                nanos = nanos / 1000 * 1000;
                break;
            }
            case 7: {
                nanos = nanos / 100 * 100;
                break;
            }
            case 8: {
                nanos = nanos / 10 * 10;
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported fractional seconds precision: " + precision);
            }
        }
        return nanos;
    }

    private static int truncateTo(int precision, int nanos) {
        switch (precision) {
            case 0: {
                return 0;
            }
            case 1: {
                return nanos / 100000000 * 100;
            }
            case 2: {
                return nanos / 10000000 * 10;
            }
            case 3: {
                return nanos / 1000000;
            }
            case 4: {
                return nanos / 100000 * 100;
            }
            case 5: {
                return nanos / 10000 * 10;
            }
            case 6: {
                return nanos / 1000;
            }
            case 7: {
                return nanos / 100 * 100;
            }
            case 8: {
                return nanos / 10 * 10;
            }
            case 9: {
                return nanos;
            }
        }
        throw new IllegalArgumentException("Unsupported fractional seconds precision: " + precision);
    }
}

