/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeSystem;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteMath;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlFunctions {
    public static final String NUMERIC_OVERFLOW_ERROR = "Numeric field overflow.";
    private static final int DFLT_NUM_PRECISION = IgniteTypeSystem.INSTANCE.getDefaultPrecision(SqlTypeName.DECIMAL);

    private IgniteSqlFunctions() {
    }

    public static ScannableTable systemRange(Object rangeStart, Object rangeEnd) {
        return new RangeTable(rangeStart, rangeEnd, 1L);
    }

    public static ScannableTable systemRange(Object rangeStart, Object rangeEnd, Object increment) {
        return new RangeTable(rangeStart, rangeEnd, increment);
    }

    public static String toString(BigDecimal x) {
        return x == null ? null : x.toPlainString();
    }

    public static BigDecimal toBigDecimal(double val, int precision, int scale) {
        return IgniteSqlFunctions.removeDefaultScale(precision, scale, IgniteSqlFunctions.toBigDecimal(BigDecimal.valueOf(val), precision, scale));
    }

    public static BigDecimal toBigDecimal(float val, int precision, int scale) {
        return IgniteSqlFunctions.removeDefaultScale(precision, scale, IgniteSqlFunctions.toBigDecimal(BigDecimal.valueOf(val), precision, scale));
    }

    private static BigDecimal removeDefaultScale(int precision, int scale, BigDecimal val) {
        BigDecimal unscaled;
        if (precision == DFLT_NUM_PRECISION && scale == 0 && val.compareTo(unscaled = val.setScale(0, IgniteMath.NUMERIC_ROUNDING_MODE)) == 0) {
            return unscaled;
        }
        return val;
    }

    public static BigDecimal toBigDecimal(long val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal(BigDecimal.valueOf(val), precision, scale);
    }

    public static BigDecimal toBigDecimal(int val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal(BigDecimal.valueOf(val), precision, scale);
    }

    public static BigDecimal toBigDecimal(short val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal(BigDecimal.valueOf(val), precision, scale);
    }

    public static BigDecimal toBigDecimal(byte val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal(BigDecimal.valueOf(val), precision, scale);
    }

    public static BigDecimal toBigDecimal(boolean val, int precision, int scale) {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal toBigDecimal(String s, int precision, int scale) {
        if (s == null) {
            return null;
        }
        return IgniteSqlFunctions.toBigDecimal(new BigDecimal(s.trim()), precision, scale);
    }

    public static BigDecimal toBigDecimal(Number val, int precision, int scale) {
        assert (precision > 0) : "Invalid precision: " + precision;
        assert (scale >= 0) : "Invalid scale: " + scale;
        if (val == null) {
            return null;
        }
        if (precision == DFLT_NUM_PRECISION) {
            return IgniteMath.convertToBigDecimal(val);
        }
        BigDecimal dec = IgniteMath.convertToBigDecimal(val);
        if (scale > precision || dec.precision() - dec.scale() > precision - scale && !dec.unscaledValue().equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException(NUMERIC_OVERFLOW_ERROR);
        }
        return dec.setScale(scale, IgniteMath.NUMERIC_ROUNDING_MODE);
    }

    public static BigDecimal toBigDecimal(Object o, int precision, int scale) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            throw new UnsupportedOperationException();
        }
        return o instanceof Number ? IgniteSqlFunctions.toBigDecimal((Number)o, precision, scale) : IgniteSqlFunctions.toBigDecimal(o.toString(), precision, scale);
    }

    public static ByteString toByteString(String s) {
        return s == null ? null : new ByteString(s.getBytes(Commons.typeFactory().getDefaultCharset()));
    }

    public static String toString(ByteString b) {
        return b == null ? null : new String(b.getBytes(), Commons.typeFactory().getDefaultCharset());
    }

    public static Object least2(Object arg0, Object arg1) {
        return IgniteSqlFunctions.leastOrGreatest(true, arg0, arg1);
    }

    public static Object skipFirstArgument(Object v1, Object v2) {
        return v2;
    }

    public static Object greatest2(Object arg0, Object arg1) {
        return IgniteSqlFunctions.leastOrGreatest(false, arg0, arg1);
    }

    private static Object leastOrGreatest(boolean least, Object arg0, Object arg1) {
        if (arg0 == null || arg1 == null) {
            return null;
        }
        assert (arg0 instanceof Comparable && arg1 instanceof Comparable) : "Unexpected class [arg0=" + arg0.getClass().getName() + ", arg1=" + arg1.getClass().getName() + "]";
        if (((Comparable)arg0).compareTo(arg1) < 0) {
            return least ? arg0 : arg1;
        }
        return least ? arg1 : arg0;
    }

    private static class RangeTable
    implements ScannableTable {
        private final Object rangeStart;
        private final Object rangeEnd;
        private final Object increment;

        RangeTable(Object rangeStart, Object rangeEnd, Object increment) {
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
            this.increment = increment;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("X", SqlTypeName.BIGINT).build();
        }

        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            if (this.rangeStart == null || this.rangeEnd == null || this.increment == null) {
                return Linq4j.emptyEnumerable();
            }
            final long rangeStart = this.convertToLongArg(this.rangeStart, "rangeStart");
            final long rangeEnd = this.convertToLongArg(this.rangeEnd, "rangeEnd");
            final long increment = this.convertToLongArg(this.increment, "increment");
            if (increment == 0L) {
                throw new IllegalArgumentException("Increment can't be 0");
            }
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<@Nullable Object[]> enumerator() {
                    return new Enumerator<Object[]>(){
                        long cur;
                        {
                            this.cur = rangeStart - increment;
                        }

                        public Object[] current() {
                            return new Object[]{this.cur};
                        }

                        public boolean moveNext() {
                            this.cur += increment;
                            return increment > 0L ? this.cur <= rangeEnd : this.cur >= rangeEnd;
                        }

                        public void reset() {
                            this.cur = rangeStart - increment;
                        }

                        public void close() {
                        }
                    };
                }
            };
        }

        private long convertToLongArg(Object val, String name) {
            if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long) {
                return ((Number)val).longValue();
            }
            throw new IllegalArgumentException("Unsupported argument type [arg=" + name + ", type=" + val.getClass().getSimpleName() + "]");
        }

        public Statistic getStatistic() {
            throw new UnsupportedOperationException();
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        public boolean isRolledUp(String column) {
            return false;
        }

        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig cfg) {
            return true;
        }
    }
}

