/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.BooleanInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ByteInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.BytesInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DoubleInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.FloatInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.IntegerInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.LongInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ObjectByteArrayInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ObjectHashInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ShortInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.SignedBytesInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.StringInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.StringNoCompareInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.TimeInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.TimestampInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.UuidInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;

public class InlineIndexKeyTypeRegistry {
    private static final Map<IndexKeyType, InlineIndexKeyType> typeMapping = new EnumMap<IndexKeyType, InlineIndexKeyType>(IndexKeyType.class);
    private static final ObjectHashInlineIndexKeyType hashObjectType = new ObjectHashInlineIndexKeyType();
    private static final StringInlineIndexKeyType optimizedCompareStringType = new StringInlineIndexKeyType();
    private static final StringNoCompareInlineIndexKeyType noCompareStringType = new StringNoCompareInlineIndexKeyType();
    private static final BytesInlineIndexKeyType bytesType = new BytesInlineIndexKeyType();
    private static final SignedBytesInlineIndexKeyType signedBytesType = new SignedBytesInlineIndexKeyType();
    private static final ObjectByteArrayInlineIndexKeyType bytesObjectType = new ObjectByteArrayInlineIndexKeyType(new BytesInlineIndexKeyType(IndexKeyType.JAVA_OBJECT));
    private static final ObjectByteArrayInlineIndexKeyType signedBytesObjectType = new ObjectByteArrayInlineIndexKeyType(new SignedBytesInlineIndexKeyType(IndexKeyType.JAVA_OBJECT));

    private static void register(IndexKeyType type, InlineIndexKeyType keyType) {
        typeMapping.put(type, keyType);
    }

    public static InlineIndexKeyType get(IndexKeyType expType, IndexKeyTypeSettings keyTypeSettings) {
        return InlineIndexKeyTypeRegistry.type(expType, keyTypeSettings);
    }

    public static InlineIndexKeyType get(IndexKey key, IndexKeyType expType, IndexKeyTypeSettings keyTypeSettings) {
        return key == NullIndexKey.INSTANCE ? InlineIndexKeyTypeRegistry.type(expType, keyTypeSettings) : InlineIndexKeyTypeRegistry.type(key.type(), keyTypeSettings);
    }

    private static InlineIndexKeyType type(IndexKeyType type, IndexKeyTypeSettings keyTypeSettings) {
        if (type == IndexKeyType.JAVA_OBJECT) {
            return InlineIndexKeyTypeRegistry.javaObjectType(keyTypeSettings);
        }
        if (type == IndexKeyType.STRING) {
            return InlineIndexKeyTypeRegistry.stringType(keyTypeSettings);
        }
        if (type == IndexKeyType.BYTES) {
            return InlineIndexKeyTypeRegistry.bytesType(keyTypeSettings);
        }
        return typeMapping.get((Object)type);
    }

    private static boolean supportInline(IndexKeyType type, IndexKeyTypeSettings keyTypeSettings) {
        if (type == IndexKeyType.JAVA_OBJECT && !keyTypeSettings.inlineObjSupported()) {
            return false;
        }
        return typeMapping.containsKey((Object)type);
    }

    private static InlineIndexKeyType javaObjectType(IndexKeyTypeSettings keyTypeSettings) {
        if (keyTypeSettings.inlineObjHash()) {
            return hashObjectType;
        }
        return keyTypeSettings.binaryUnsigned() ? bytesObjectType : signedBytesObjectType;
    }

    private static InlineIndexKeyType stringType(IndexKeyTypeSettings keyTypeSettings) {
        return keyTypeSettings.stringOptimizedCompare() ? optimizedCompareStringType : noCompareStringType;
    }

    private static InlineIndexKeyType bytesType(IndexKeyTypeSettings keyTypeSettings) {
        return keyTypeSettings.binaryUnsigned() ? bytesType : signedBytesType;
    }

    public static List<InlineIndexKeyType> types(Collection<IndexKeyDefinition> keyDefs, IndexKeyTypeSettings settings) {
        ArrayList<InlineIndexKeyType> keyTypes = new ArrayList<InlineIndexKeyType>();
        for (IndexKeyDefinition keyDef : keyDefs) {
            if (!InlineIndexKeyTypeRegistry.supportInline(keyDef.idxType(), settings)) break;
            keyTypes.add(InlineIndexKeyTypeRegistry.type(keyDef.idxType(), settings));
        }
        return Collections.unmodifiableList(keyTypes);
    }

    static {
        InlineIndexKeyTypeRegistry.register(IndexKeyType.BOOLEAN, new BooleanInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.BYTE, new ByteInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.DATE, new DateInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.DOUBLE, new DoubleInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.FLOAT, new FloatInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.INT, new IntegerInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.SHORT, new ShortInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.LONG, new LongInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.TIME, new TimeInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.TIMESTAMP, new TimestampInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.UUID, new UuidInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(IndexKeyType.JAVA_OBJECT, hashObjectType);
        InlineIndexKeyTypeRegistry.register(IndexKeyType.STRING, optimizedCompareStringType);
        InlineIndexKeyTypeRegistry.register(IndexKeyType.BYTES, bytesType);
    }
}

