/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroup(value={"destroyAllCaches", "caches"}, onlyOneOf=true, optional=false)
public class CacheDestroyCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Argument(description="specifies a comma-separated list of cache names to be destroyed", example="cache1,...,cacheN")
    private String[] caches;
    @Argument(description="permanently destroy all user-created caches")
    private boolean destroyAllCaches;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeArray(out, this.caches);
        out.writeBoolean(this.destroyAllCaches);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.caches = U.readArray(in, String.class);
        this.destroyAllCaches = in.readBoolean();
    }

    public boolean destroyAllCaches() {
        return this.destroyAllCaches;
    }

    public void destroyAllCaches(boolean destroyAllCaches) {
        this.destroyAllCaches = destroyAllCaches;
    }

    public String[] caches() {
        return this.caches;
    }

    public void caches(String[] caches) {
        this.caches = caches;
    }
}

