/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.trait;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.query.calcite.trait.Destination;

public final class Partitioned<Row>
implements Destination<Row> {
    private final List<List<UUID>> assignments;
    private final ToIntFunction<Row> partFun;

    public Partitioned(List<List<UUID>> assignments, ToIntFunction<Row> partFun) {
        this.assignments = assignments;
        this.partFun = partFun;
    }

    @Override
    public List<UUID> targets(Row row) {
        return this.assignments.get(this.partFun.applyAsInt(row) % this.assignments.size());
    }

    @Override
    public List<UUID> targets() {
        return this.assignments.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }
}

