/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexBound;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rule.ImmutableIndexMinMaxRule;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.util.typedef.F;
import org.immutables.value.Value;

@Value.Enclosing
public class IndexMinMaxRule
extends RelRule<Config> {
    public static final IndexMinMaxRule INSTANCE = Config.DEFAULT.toRule();

    private IndexMinMaxRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteAggregate aggr = (IgniteAggregate)call.rel(0);
        IgniteIndexScan idxScan = (IgniteIndexScan)call.rel(1);
        IgniteTable table = (IgniteTable)idxScan.getTable().unwrap(IgniteTable.class);
        IgniteIndex idx = table.getIndex(idxScan.indexName());
        if (table.isIndexRebuildInProgress() || idxScan.condition() != null || idxScan.projects() != null || aggr.getGroupCount() > 0 || aggr.getAggCallList().stream().filter(a -> a.getAggregation().getKind() == SqlKind.MIN || a.getAggregation().getKind() == SqlKind.MAX).count() != 1L || idx.collation().getFieldCollations().isEmpty() || ((RelFieldCollation)idx.collation().getFieldCollations().get(0)).getFieldIndex() != idxScan.requiredColumns().nextSetBit(0)) {
            return;
        }
        SqlAggFunction aggFun = ((AggregateCall)aggr.getAggCallList().get(0)).getAggregation();
        boolean firstIdxVal = aggFun.getKind() == SqlKind.MIN != ((RelFieldCollation)idx.collation().getFieldCollations().get(0)).getDirection().isDescending();
        IgniteIndexBound idxMinMaxRel = new IgniteIndexBound(idxScan.getTable(), idxScan.getCluster(), idxScan.getTraitSet().replace((RelTrait)RewindabilityTrait.REWINDABLE), idxScan.indexName(), firstIdxVal, idxScan.requiredColumns());
        call.transformTo((RelNode)aggr.clone(aggr.getCluster(), F.asList((Object)idxMinMaxRel)));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIndexMinMaxRule.Config.of().withDescription("IndexMinMaxRule").withOperandSupplier(r -> r.operand(IgniteAggregate.class).oneInput(i -> i.operand(IgniteIndexScan.class).anyInputs()));

        default public IndexMinMaxRule toRule() {
            return new IndexMinMaxRule(this);
        }
    }
}

