/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.websession;

import java.sql.Timestamp;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.cache.PlatformCache;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheExtension;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.utils.PlatformWriterClosure;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionData;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionLockProcessor;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionLockResult;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionSetAndUnlockProcessor;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PlatformDotNetSessionCacheExtension
implements PlatformCacheExtension {
    private static final int EXT_ID = 0;
    private static final int OP_LOCK = 1;
    private static final int OP_SET_AND_UNLOCK = 2;
    private static final int OP_GET = 3;
    private static final int OP_PUT = 4;
    private static final int OP_REMOVE = 5;

    @Override
    public int id() {
        return 0;
    }

    @Override
    public long processInOutStreamLong(PlatformCache target, int type, BinaryRawReaderEx reader, PlatformMemory mem) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                String key = reader.readString();
                UUID lockNodeId = reader.readUuid();
                long lockId = reader.readLong();
                Timestamp lockTime = reader.readTimestamp();
                final PlatformDotNetSessionLockResult res = (PlatformDotNetSessionLockResult)target.rawCache().invoke(key, new PlatformDotNetSessionLockProcessor(lockNodeId, lockId, lockTime), new Object[0]);
                return target.writeResult(mem, res, new PlatformWriterClosure(){

                    public void write(BinaryRawWriterEx writer, Object val) {
                        res.writeBinary(writer);
                    }
                });
            }
            case 2: {
                PlatformDotNetSessionSetAndUnlockProcessor proc;
                String key = reader.readString();
                if (reader.readBoolean()) {
                    PlatformDotNetSessionData data = new PlatformDotNetSessionData();
                    data.readBinary(reader);
                    proc = new PlatformDotNetSessionSetAndUnlockProcessor(data);
                } else {
                    UUID lockNodeId = reader.readUuid();
                    long lockId = reader.readLong();
                    proc = new PlatformDotNetSessionSetAndUnlockProcessor(lockNodeId, lockId);
                }
                target.rawCache().invoke(key, proc, new Object[0]);
                return target.writeResult(mem, null);
            }
            case 3: {
                String key = reader.readString();
                final PlatformDotNetSessionData data = (PlatformDotNetSessionData)target.rawCache().get(key);
                return target.writeResult(mem, data, new PlatformWriterClosure(){

                    public void write(BinaryRawWriterEx writer, Object val) {
                        data.writeBinary(writer);
                    }
                });
            }
            case 4: {
                String key = reader.readString();
                PlatformDotNetSessionData data = new PlatformDotNetSessionData();
                data.readBinary(reader);
                target.rawCache().put(key, data);
                return target.writeResult(mem, null);
            }
            case 5: {
                String key = reader.readString();
                target.rawCache().remove(key);
                return target.writeResult(mem, null);
            }
        }
        throw new IgniteCheckedException("Unsupported operation type: " + type);
    }

    public String toString() {
        return S.toString(PlatformDotNetSessionCacheExtension.class, this);
    }
}

