/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.apache.guacamole.tunnel.InterceptedStream;
import org.apache.guacamole.tunnel.StreamInterceptingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamInterceptingFilter
extends StreamInterceptingFilter<InputStream> {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamInterceptingFilter.class);

    public InputStreamInterceptingFilter(GuacamoleTunnel tunnel) {
        super(tunnel);
    }

    private void sendBlob(String index, byte[] blob) {
        this.sendInstruction(new GuacamoleInstruction("blob", new String[]{index, BaseEncoding.base64().encode(blob)}));
    }

    private void sendEnd(String index) {
        this.sendInstruction(new GuacamoleInstruction("end", new String[]{index}));
    }

    private void readNextBlob(InterceptedStream<InputStream> stream) {
        block3: {
            try {
                byte[] blob = new byte[6048];
                int length = ((InputStream)stream.getStream()).read(blob);
                if (length == -1) {
                    this.closeInterceptedStream(stream);
                    return;
                }
                this.sendBlob(stream.getIndex(), Arrays.copyOf(blob, length));
            }
            catch (IOException e) {
                logger.debug("Unable to read data of intercepted input stream.", (Throwable)e);
                if (!this.closeInterceptedStream(stream)) break block3;
                this.sendEnd(stream.getIndex());
            }
        }
    }

    private void handleAck(GuacamoleInstruction instruction) {
        List args = instruction.getArgs();
        if (args.size() < 3) {
            return;
        }
        String index = (String)args.get(0);
        InterceptedStream stream = this.getInterceptedStream(index);
        if (stream == null) {
            return;
        }
        String status = (String)args.get(2);
        if (!status.equals("0")) {
            int code;
            try {
                code = Integer.parseInt(status);
            }
            catch (NumberFormatException e) {
                logger.debug("Translating invalid status code \"{}\" to SERVER_ERROR.", (Object)status);
                code = GuacamoleStatus.SERVER_ERROR.getGuacamoleStatusCode();
            }
            stream.setStreamError(code, (String)args.get(1));
            this.closeInterceptedStream(stream);
            return;
        }
        this.readNextBlob(stream);
    }

    public GuacamoleInstruction filter(GuacamoleInstruction instruction) throws GuacamoleException {
        if (instruction.getOpcode().equals("ack")) {
            this.handleAck(instruction);
        }
        return instruction;
    }

    protected void handleInterceptedStream(InterceptedStream<InputStream> stream) {
        this.readNextBlob(stream);
    }
}

